/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.test.testcase.activity;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import org.droidparts.test.activity.TestFragment;
import org.droidparts.test.testcase.activity.TestActivityTest;

public class FragmentTest
extends TestActivityTest {
    private Bundle args;
    private Bundle state;
    private String str;

    protected void setUp() throws Exception {
        super.setUp();
        this.args = new Bundle();
        this.state = new Bundle();
        this.str = "str";
        this.args.putString("str", this.str);
    }

    public void testInjectArgument() {
        TestFragment tf = this.makeFragment();
        tf.onCreate(null);
        FragmentTest.assertFalse((boolean)tf.isInjected());
        FragmentTest.assertNull((Object)tf.str);
        tf.onCreateView(this.getLayoutInflater(), null, null);
        FragmentTest.assertTrue((boolean)tf.isInjected());
        FragmentTest.assertEquals((String)this.str, (String)tf.str);
    }

    public void testSaveInstanceNonInjected() {
        TestFragment tf = this.makeFragment();
        tf.onCreate(null);
        FragmentTest.assertNull((Object)tf.str);
        tf.onSaveInstanceState(this.state);
        tf.onCreateView(this.getLayoutInflater(), null, this.state);
        FragmentTest.assertEquals((String)"str", (String)tf.str);
    }

    public void testSaveInstanceInjected() {
        TestFragment tf = this.makeFragment();
        tf.onCreateView(LayoutInflater.from((Context)this.getActivity()), null, null);
        FragmentTest.assertEquals((String)this.str, (String)tf.str);
        tf.str = "changed";
        tf.onSaveInstanceState(this.state);
        tf.str = null;
        tf.onCreateView(this.getLayoutInflater(), null, this.state);
        FragmentTest.assertEquals((String)"changed", (String)tf.str);
    }

    public void testSaveInstanceInjectedNested() {
        TestFragment tf = this.makeFragment();
        tf.onCreateView(LayoutInflater.from((Context)this.getActivity()), null, null);
        tf.map.put(1, new TestFragment.KV<String, String>("k", "v"));
        tf.onSaveInstanceState(this.state);
        tf.map = null;
        tf.onCreateView(this.getLayoutInflater(), null, this.state);
        FragmentTest.assertNotNull(tf.map);
        FragmentTest.assertTrue((boolean)tf.map.containsKey(1));
        FragmentTest.assertEquals((String)"v", (String)((String)tf.map.get((Object)Integer.valueOf((int)1)).v));
    }

    private TestFragment makeFragment() {
        TestFragment tf = new TestFragment();
        tf.setArguments(this.args);
        return tf;
    }
}

