/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.test.testcase.serialize;

import android.test.AndroidTestCase;
import android.test.AssertionFailedError;
import java.io.InputStream;
import java.util.ArrayList;
import org.droidparts.persist.serializer.SerializerException;
import org.droidparts.persist.serializer.XMLSerializer;
import org.droidparts.test.model.Album;
import org.droidparts.test.model.Album2;
import org.droidparts.test.model.AlbumFail;
import org.droidparts.test.model.Collections;
import org.droidparts.util.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTestCase
extends AndroidTestCase {
    public void testAlbums() throws Exception {
        Document albumsDoc = this.getXMLDocument(2130903042);
        NodeList nl = albumsDoc.getElementsByTagName("album");
        XMLSerializer serializer = new XMLSerializer(Album.class, this.getContext());
        ArrayList albums = serializer.deserializeAll(nl);
        XMLTestCase.assertEquals((int)2, (int)albums.size());
        XMLTestCase.assertEquals((String)"Diamond", (String)((Album)((Object)albums.get((int)0))).name);
        XMLTestCase.assertEquals((int)2009, (int)((Album)((Object)albums.get((int)1))).year);
    }

    public void testAlbum2() throws Exception {
        Document albumDoc = this.getXMLDocument(2130903040);
        XMLSerializer serializer = new XMLSerializer(Album2.class, this.getContext());
        Album2 a2 = (Album2)serializer.deserialize((Node)albumDoc);
        XMLTestCase.assertEquals((String)"Iris", (String)a2.name);
        XMLTestCase.assertEquals((int)2009, (int)a2.year);
        XMLTestCase.assertEquals((int)2, (int)a2.albumArr.length);
        XMLTestCase.assertEquals((int)2, (int)a2.albumList.size());
        XMLTestCase.assertEquals((int)3, (int)a2.ints.length);
        XMLTestCase.assertEquals((int)3, (int)a2.integers.size());
        XMLTestCase.assertEquals((int)5, (int)a2.ints[1]);
        XMLTestCase.assertEquals((int)100500, (int)a2.integers.get(2));
        XMLTestCase.assertEquals((int)a2.integers.size(), (int)a2.integersHinted.size());
        XMLTestCase.assertTrue((boolean)a2.integersHintedWrong.isEmpty());
    }

    public void testFail() throws Exception {
        Document albumDoc = this.getXMLDocument(2130903040);
        XMLSerializer serializer = new XMLSerializer(AlbumFail.class, this.getContext());
        try {
            serializer.deserialize((Node)albumDoc);
            XMLTestCase.assertTrue((boolean)false);
        }
        catch (Exception e) {
            XMLTestCase.assertTrue((boolean)(e instanceof SerializerException));
        }
    }

    public void testCollectionsFail() throws Exception {
        try {
            Document doc = this.getXMLDocument(2130903044);
            XMLSerializer ser = new XMLSerializer(Collections.class, this.getContext());
            ser.deserialize((Node)doc);
        }
        catch (Exception e) {
            XMLTestCase.assertTrue((boolean)(e instanceof SerializerException));
            return;
        }
        throw new AssertionFailedError();
    }

    private Document getXMLDocument(int resId) throws Exception {
        String xml = IOUtils.readToString((InputStream)this.getContext().getResources().openRawResource(resId));
        return XMLSerializer.parseDocument((String)xml);
    }
}

