/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.test.testcase.rest;

import android.test.AndroidTestCase;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.droidparts.net.http.HTTPException;
import org.droidparts.net.http.HTTPResponse;
import org.droidparts.net.http.RESTClient2;
import org.droidparts.net.http.UserAgent;
import org.droidparts.net.http.worker.HTTPWorker;
import org.droidparts.net.http.worker.HttpClientWorker;
import org.droidparts.net.http.worker.HttpURLConnectionWorker;

public class RESTClientPostMultipart
extends AndroidTestCase {
    private static final String URL = "http://posttestserver.com/post.php?dump";
    private static final String FILE_NAME = "test";
    private static final String FILE_BODY = "Test POST multipart file";
    private static final String CONTENT_TYPE = "text/plain";

    public void testPostMultipartURLConnection() throws Exception {
        HttpURLConnectionWorker worker = new HttpURLConnectionWorker(this.getContext(), UserAgent.getDefault());
        this.testPostMultipartFile((HTTPWorker)worker);
        this.testPostMultipartBytes((HTTPWorker)worker);
    }

    public void testPostMultipartHttpClient() throws Exception {
        HttpClientWorker worker = new HttpClientWorker(UserAgent.getDefault());
        this.testPostMultipartFile((HTTPWorker)worker);
        this.testPostMultipartBytes((HTTPWorker)worker);
    }

    private void testPostMultipartFile(HTTPWorker worker) throws Exception {
        RESTClient2 client = new RESTClient2(this.getContext(), worker);
        File file = this.writeTestFile(FILE_BODY);
        HTTPResponse resp = client.postMultipart(URL, FILE_NAME, file);
        this.assertPostMultipartResponse(resp);
        resp = client.postMultipart(URL, FILE_NAME, CONTENT_TYPE, file);
        this.assertPostMultipartResponse(resp);
    }

    private void testPostMultipartBytes(HTTPWorker worker) throws Exception {
        RESTClient2 client = new RESTClient2(this.getContext(), worker);
        byte[] fileBytes = FILE_BODY.getBytes();
        HTTPResponse resp = client.postMultipart(URL, FILE_NAME, FILE_NAME, fileBytes);
        this.assertPostMultipartResponse(resp);
        resp = client.postMultipart(URL, FILE_NAME, CONTENT_TYPE, FILE_NAME, fileBytes);
        this.assertPostMultipartResponse(resp);
    }

    private File writeTestFile(String data) throws IOException {
        File file = new File(this.getContext().getCacheDir(), "test.txt");
        FileWriter fw = new FileWriter(file);
        fw.write(data);
        fw.close();
        return file;
    }

    private void assertPostMultipartResponse(HTTPResponse response) throws HTTPException {
        RESTClientPostMultipart.assertNotNull((Object)response);
        String body = response.body;
        Pattern pattern = Pattern.compile("Uploaded File: (.+)");
        Matcher matcher = pattern.matcher(body);
        RESTClientPostMultipart.assertTrue((boolean)matcher.find());
        String fileUrl = matcher.group(1);
        RESTClient2 client = new RESTClient2(this.getContext());
        RESTClientPostMultipart.assertEquals((String)client.get((String)fileUrl).body, (String)FILE_BODY);
    }
}

