/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.test.testcase.serialize;

import android.content.Context;
import android.test.AndroidTestCase;
import android.test.AssertionFailedError;
import java.util.ArrayList;
import org.droidparts.model.Model;
import org.droidparts.persist.serializer.JSONSerializer;
import org.droidparts.persist.serializer.SerializerException;
import org.droidparts.test.model.Album;
import org.droidparts.test.model.Collections;
import org.droidparts.test.model.Nested;
import org.droidparts.test.model.Primitives;
import org.droidparts.util.ResourceUtils;
import org.droidparts.util.Strings;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONTestCase
extends AndroidTestCase {
    public void testPrimitives() throws Exception {
        JSONSerializer serializer = new JSONSerializer(Primitives.class, this.getContext());
        Primitives primitives = (Primitives)serializer.deserialize(this.getPrimitives());
        JSONTestCase.assertNotNull((Object)primitives.strArr);
        JSONObject obj = serializer.serialize((Model)primitives);
        JSONTestCase.assertEquals((int)1, (int)obj.getInt("int1"));
        JSONTestCase.assertEquals((int)2, (int)obj.getInt("int2"));
        JSONTestCase.assertEquals((Object)0.5, (Object)obj.getDouble("float1"));
        JSONTestCase.assertEquals((Object)2.5, (Object)obj.getDouble("float2"));
        JSONTestCase.assertEquals((boolean)true, (boolean)obj.getBoolean("boolean1"));
        JSONTestCase.assertEquals((boolean)true, (boolean)obj.getBoolean("boolean2"));
        JSONTestCase.assertEquals((boolean)true, (boolean)obj.getBoolean("boolean3"));
        JSONTestCase.assertEquals((boolean)false, (boolean)obj.getBoolean("boolean4"));
        JSONTestCase.assertEquals((String)"str", (String)obj.getString("string1"));
        JSONTestCase.assertEquals((int)2, (int)obj.getJSONArray("string_array").length());
        JSONTestCase.assertEquals((String)"two", (String)obj.getJSONArray("string_array").getString(1));
    }

    public void testAlbums() throws Exception {
        JSONSerializer serializer = new JSONSerializer(Album.class, this.getContext());
        ArrayList albums = serializer.deserializeAll(this.getAlbums());
        JSONTestCase.assertEquals((int)2, (int)albums.size());
        JSONTestCase.assertEquals((String)"Diamond", (String)((Album)((Object)albums.get((int)0))).name);
        JSONTestCase.assertEquals((int)2009, (int)((Album)((Object)albums.get((int)1))).year);
    }

    public void testNestedKeys() throws Exception {
        JSONTestCase.assertEquals((String)"obj->\u001dkey", (String)Strings.join((Object[])new String[]{"obj", "key"}, (String)"->\u001d"));
        JSONSerializer serializer = new JSONSerializer(Nested.class, this.getContext());
        Nested model = (Nested)serializer.deserialize(this.getNested());
        JSONTestCase.assertEquals((String)"str", (String)model.str);
        JSONObject obj = serializer.serialize((Model)model);
        JSONTestCase.assertEquals((String)"str", (String)obj.getJSONObject("sub_obj").getString("str"));
    }

    public void testCollections() throws Exception {
        JSONSerializer ser = new JSONSerializer(Collections.class, this.getContext());
        Collections coll = (Collections)ser.deserialize(new JSONObject(this.getJSONString(2130903045)));
        JSONTestCase.assertEquals((int)2, (int)coll.albumsArr.length);
        JSONTestCase.assertEquals((int)2, (int)coll.albumsColl.size());
        JSONTestCase.assertEquals((int)2, (int)coll.map.size());
        JSONTestCase.assertTrue((boolean)coll.map.containsKey(2009));
        JSONTestCase.assertEquals((String)"Iris", (String)coll.map.get(2009));
        JSONObject obj = ser.serialize((Model)coll);
        JSONTestCase.assertTrue((boolean)obj.has("map"));
    }

    public void testCollectionsFail() throws Exception {
        try {
            JSONSerializer ser = new JSONSerializer(Collections.class, this.getContext());
            ser.deserialize(new JSONObject(this.getJSONString(2130903043)));
        }
        catch (Exception e) {
            JSONTestCase.assertTrue((boolean)(e instanceof SerializerException));
            return;
        }
        throw new AssertionFailedError();
    }

    private JSONObject getPrimitives() throws Exception {
        return new JSONObject(this.getJSONString(2130903047));
    }

    private JSONObject getNested() throws Exception {
        return new JSONObject(this.getJSONString(2130903046));
    }

    private JSONArray getAlbums() throws Exception {
        return new JSONArray(this.getJSONString(2130903041));
    }

    private String getJSONString(int resId) {
        return ResourceUtils.readRawResource((Context)this.getContext(), (int)resId);
    }
}

