/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.test.persist.sql;

import android.content.Context;
import java.util.ArrayList;
import java.util.Collection;
import org.droidparts.model.Entity;
import org.droidparts.persist.sql.EntityManager;
import org.droidparts.persist.sql.stmt.Is;
import org.droidparts.persist.sql.stmt.Select;
import org.droidparts.test.model.Album;
import org.droidparts.test.model.AlbumToTag;
import org.droidparts.test.model.Tag;
import org.droidparts.test.persist.DB;

public class AlbumManager
extends EntityManager<Album>
implements DB {
    private final EntityManager<AlbumToTag> albumToTagManager;
    private final EntityManager<Tag> tagManager;

    public AlbumManager(Context ctx) {
        super(Album.class, ctx);
        this.albumToTagManager = new EntityManager(AlbumToTag.class, ctx);
        this.tagManager = new EntityManager(Tag.class, ctx);
    }

    public ArrayList<Tag> getTags(long albumId) {
        ArrayList tags = new ArrayList();
        Select select = this.tagManager.select().where("_id", Is.IN, new Object[]{this.getTagIds(albumId)});
        tags = this.tagManager.readAll(select);
        return tags;
    }

    public void addTags(long albumId, Collection<Tag> tags) {
        Album album = (Album)this.read(albumId);
        for (Tag tag : tags) {
            boolean success = this.tagManager.create((Entity)tag);
            if (!success) {
                Select select = this.tagManager.select().where("_name_", Is.EQUAL, new Object[]{tag.name});
                tag = (Tag)this.tagManager.readFirst(select);
            }
            this.albumToTagManager.create((Entity)new AlbumToTag(album, tag));
        }
    }

    public long[] getTagIds(long albumId) {
        Select select = this.albumToTagManager.select().columns(new String[]{"_tag_"}).where("_album_", Is.EQUAL, new Object[]{albumId});
        return this.albumToTagManager.readIds(select);
    }
}

