/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.test.testcase.rest;

import android.test.AndroidTestCase;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.droidparts.net.http.HTTPException;
import org.droidparts.net.http.HTTPResponse;
import org.droidparts.net.http.RESTClient;
import org.droidparts.net.http.RESTClient2;
import org.droidparts.net.http.UserAgent;
import org.droidparts.net.http.worker.HTTPWorker;
import org.droidparts.net.http.worker.HttpClientWorker;

public class RESTClientPostMultipart
extends AndroidTestCase {
    private static final String POST_MULTIPART_URL = "http://posttestserver.com/post.php?dump";
    private static final String POST_MULTIPART_FILE_NAME = "test";
    private static final String POST_MULTIPART_FILE_BODY = "Test POST multipart file";
    private static final String POST_MULTIPART_CONTENT_TYPE = "text/plain";

    public void testPostMultipart() throws Exception {
        this.testPostMultipart(null);
    }

    public void testPostMultipartLegacy() throws Exception {
        HttpClientWorker worker = new HttpClientWorker(UserAgent.getDefault());
        this.testPostMultipart((HTTPWorker)worker);
    }

    public void testPostMultipart(HTTPWorker worker) throws Exception {
        RESTClient client = worker == null ? new RESTClient(this.getContext()) : new RESTClient(this.getContext(), worker);
        File file = this.writeTestFile(POST_MULTIPART_FILE_BODY);
        HTTPResponse resp = client.postMultipart(POST_MULTIPART_URL, POST_MULTIPART_FILE_NAME, file);
        this.assertPostMultipartResponse(resp);
        resp = client.postMultipart(POST_MULTIPART_URL, POST_MULTIPART_FILE_NAME, POST_MULTIPART_CONTENT_TYPE, file);
        this.assertPostMultipartResponse(resp);
    }

    private File writeTestFile(String data) throws IOException {
        File file = new File(this.getContext().getCacheDir(), "test.txt");
        FileWriter fw = new FileWriter(file);
        fw.write(data);
        fw.close();
        return file;
    }

    private void assertPostMultipartResponse(HTTPResponse response) throws HTTPException {
        RESTClientPostMultipart.assertNotNull((Object)response);
        String body = response.body;
        Pattern pattern = Pattern.compile("Uploaded File: (.+)");
        Matcher matcher = pattern.matcher(body);
        RESTClientPostMultipart.assertTrue((boolean)matcher.find());
        String fileUrl = matcher.group(1);
        RESTClient2 client = new RESTClient2(this.getContext());
        RESTClientPostMultipart.assertEquals((String)client.get((String)fileUrl).body, (String)POST_MULTIPART_FILE_BODY);
    }
}

