/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.test.testcase;

import android.database.Cursor;
import android.test.AndroidTestCase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.droidparts.model.Entity;
import org.droidparts.persist.sql.EntityManager;
import org.droidparts.persist.sql.stmt.Is;
import org.droidparts.test.model.Album;
import org.droidparts.test.model.AlbumToTag;
import org.droidparts.test.model.Primitives;
import org.droidparts.test.model.Tag;
import org.droidparts.test.model.Track;
import org.droidparts.test.persist.DB;
import org.droidparts.test.persist.sql.AlbumManager;
import org.droidparts.test.persist.sql.TrackManager;

public class EntityTestCase
extends AndroidTestCase
implements DB {
    private static final String[] ALBUMS = new String[]{"Diamond", "Iris"};
    private static final int[] YEARS = new int[]{2007, 2009};
    private static final String[] TRACKS = new String[]{"Diamond", "Beautiful", "Stay", "Secret Desire", "The Sun", "Buddha"};
    private static final String[] TAGS = new String[]{"downtempo", "lounge", "chillout"};
    private EntityManager<Primitives> primitivesManager;
    private EntityManager<AlbumToTag> albumToTagManager;
    private AlbumManager albumManager;
    private EntityManager<Tag> tagManager;
    private TrackManager trackManager;

    protected void setUp() {
        if (this.primitivesManager == null) {
            this.primitivesManager = new EntityManager(Primitives.class, this.getContext());
            this.albumToTagManager = new EntityManager(AlbumToTag.class, this.getContext());
            this.tagManager = new EntityManager(Tag.class, this.getContext());
            this.albumManager = new AlbumManager(this.getContext());
            this.trackManager = new TrackManager(this.getContext());
        }
    }

    protected void tearDown() {
        this.primitivesManager.delete().execute();
        this.tagManager.delete().execute();
        this.albumManager.delete().execute();
        this.trackManager.delete().execute();
    }

    public void testUniqueIndex() {
        Album album = new Album(ALBUMS[0], YEARS[0]);
        Tag tag = new Tag(TAGS[0]);
        AlbumToTag att = new AlbumToTag(album, tag);
        EntityTestCase.assertTrue((boolean)this.albumToTagManager.create((Entity)att));
        EntityTestCase.assertFalse((boolean)this.albumToTagManager.create((Entity)att));
        album.name = ALBUMS[1];
        album.id = 0L;
        EntityTestCase.assertTrue((boolean)this.albumToTagManager.create((Entity)att));
        EntityTestCase.assertEquals((int)2, (int)this.albumToTagManager.select().count());
    }

    public void testCRUD() {
        Album album1 = this.createAlbum();
        EntityTestCase.assertFalse((album1.id == 0L ? 1 : 0) != 0);
        Album album2 = (Album)this.albumManager.read(album1.id);
        EntityTestCase.assertEquals((String)album1.name, (String)album2.name);
        album2.name = ALBUMS[1];
        this.albumManager.update(album2);
        Album album3 = (Album)this.albumManager.read(album2.id);
        EntityTestCase.assertEquals((String)album2.name, (String)album3.name);
        EntityTestCase.assertEquals((long)album1.id, (long)album3.id);
        this.albumManager.delete(album1.id);
        EntityTestCase.assertNull((Object)this.albumManager.read(album1.id));
    }

    public void testUniqueAndNull() {
        Album album1 = new Album(ALBUMS[0], YEARS[0]);
        album1.comment = TAGS[0];
        boolean created = this.albumManager.create(album1);
        EntityTestCase.assertTrue((boolean)created);
        Album album2 = new Album();
        created = this.albumManager.create(album2);
        EntityTestCase.assertFalse((boolean)created);
        album2.name = album1.name;
        created = this.albumManager.create(album2);
        EntityTestCase.assertFalse((boolean)created);
        album2.name = album1.name + "x";
        created = this.albumManager.create(album2);
        EntityTestCase.assertTrue((boolean)created);
        int count = this.albumManager.select().whereId(new long[]{album1.id}).count();
        EntityTestCase.assertEquals((int)1, (int)count);
        Cursor cursor = this.albumManager.select().where("_comment_", Is.NOT_NULL, new Object[0]).execute();
        EntityTestCase.assertEquals((int)1, (int)cursor.getCount());
        cursor.moveToFirst();
        Album album11 = (Album)this.albumManager.readRow(cursor);
        EntityTestCase.assertEquals((String)album1.name, (String)album11.name);
        cursor.close();
        cursor = this.albumManager.select().where("_comment_", Is.NULL, new Object[0]).execute();
        EntityTestCase.assertEquals((int)1, (int)cursor.getCount());
        cursor.moveToFirst();
        Album album21 = (Album)this.albumManager.readRow(cursor);
        EntityTestCase.assertEquals((String)album2.name, (String)album21.name);
        cursor.close();
    }

    public void testModel() {
        Album album = this.createAlbum();
        album.nested.str = "str";
        this.albumManager.update(album);
        album = (Album)this.albumManager.read(album.id);
        EntityTestCase.assertEquals((String)"str", (String)album.nested.str);
    }

    public void testDate() {
        long now = System.currentTimeMillis();
        Primitives pri = new Primitives();
        pri.date = new Date(now);
        pri.dates.add(pri.date);
        EntityTestCase.assertTrue((boolean)this.primitivesManager.create((Entity)pri));
        pri = (Primitives)this.primitivesManager.read(pri.id);
        EntityTestCase.assertEquals((long)now, (long)pri.date.getTime());
        EntityTestCase.assertEquals((int)1, (int)pri.dates.size());
        EntityTestCase.assertEquals((long)now, (long)pri.dates.get(0).getTime());
    }

    public void testEnum() {
        Primitives pri = new Primitives();
        pri.en = Primitives.En.HI;
        pri.enArr = new Primitives.En[]{Primitives.En.HI, Primitives.En.THERE};
        this.primitivesManager.create((Entity)pri);
        pri = (Primitives)this.primitivesManager.read(pri.id);
        EntityTestCase.assertEquals((Object)((Object)Primitives.En.HI), (Object)((Object)pri.en));
        EntityTestCase.assertEquals((int)Primitives.En.THERE.id, (int)pri.enArr[1].id);
    }

    public void testArraysAndCollections() {
        Primitives pri = new Primitives();
        pri.strArr = new String[]{"one", "two"};
        pri.intArr = new int[]{10, 20, 30};
        pri.strList.addAll(Arrays.asList(pri.strArr));
        pri.doubleSet.add(100.5);
        pri.doubleSet.add(12.5);
        EntityTestCase.assertTrue((boolean)this.primitivesManager.create((Entity)pri));
        pri = (Primitives)this.primitivesManager.read(pri.id);
        EntityTestCase.assertEquals((int)2, (int)pri.strArr.length);
        EntityTestCase.assertEquals((int)30, (int)pri.intArr[2]);
        EntityTestCase.assertTrue((boolean)pri.strList.contains("one"));
        EntityTestCase.assertTrue((boolean)pri.doubleSet.contains(12.5));
    }

    public void testWhereId() {
        this.createAlbums(10);
        int count = this.albumManager.select().whereId(new long[]{5L, 8L}).count();
        EntityTestCase.assertEquals((int)2, (int)count);
        count = this.albumManager.select().whereId(new long[]{3L}).count();
        EntityTestCase.assertEquals((int)1, (int)count);
        count = this.albumManager.select().whereId(new long[]{15L}).count();
        EntityTestCase.assertEquals((int)0, (int)count);
    }

    public void testBetween() {
        this.createAlbums(20);
        int count = this.albumManager.select().where("_id", Is.BETWEEN, new Object[]{5, 10}).count();
        EntityTestCase.assertEquals((int)6, (int)count);
        count = this.albumManager.select().where("_id", Is.NOT_BETWEEN, new Object[]{5, 10}).count();
        EntityTestCase.assertEquals((int)14, (int)count);
    }

    public void testIn() {
        this.createAlbums(3);
        int[] arr = new int[]{1, 2};
        int count = this.albumManager.select().where("_id", Is.IN, new Object[]{arr}).count();
        EntityTestCase.assertEquals((int)2, (int)count);
        count = this.albumManager.select().where("_id", Is.NOT_IN, new Object[]{arr}).count();
        EntityTestCase.assertEquals((int)1, (int)count);
    }

    public void testLike() {
        ArrayList<Album> list = new ArrayList<Album>();
        for (String str : TRACKS) {
            Album album = new Album();
            album.name = str;
            list.add(album);
        }
        this.albumManager.create(list);
        int count = this.albumManager.select().where("_name_", Is.LIKE, new Object[]{"%%udd%%"}).count();
        EntityTestCase.assertEquals((int)1, (int)count);
        count = this.albumManager.select().where("_name_", Is.NOT_LIKE, new Object[]{"%%udd%%"}).count();
        EntityTestCase.assertEquals((int)(TRACKS.length - 1), (int)count);
    }

    public void testForeignKeys() {
        Album album = this.createAlbum();
        for (String name : TRACKS) {
            Track track = new Track();
            track.album = album;
            track.name = name;
            this.trackManager.create(track);
        }
        EntityTestCase.assertEquals((int)TRACKS.length, (int)this.trackManager.select().where("_album_", Is.EQUAL, new Object[]{album.id}).count());
        this.albumManager.delete(album.id);
        EntityTestCase.assertEquals((int)0, (int)this.trackManager.select().count());
    }

    public void testEagerForeignKeys() {
        Album album = this.createAlbum();
        Track track = new Track();
        track.name = TRACKS[0];
        track.album = album;
        track.nullableAlbum = album;
        this.trackManager.create(track);
        track = (Track)this.trackManager.read(track.id);
        EntityTestCase.assertNotNull((Object)track.album.name);
        EntityTestCase.assertNull((Object)track.nullableAlbum.name);
    }

    public void testUniqueAndNullable() {
        Album album = new Album();
        EntityTestCase.assertFalse((boolean)this.albumManager.create(album));
        album.name = "name";
        EntityTestCase.assertTrue((boolean)this.albumManager.create(album));
        EntityTestCase.assertFalse((boolean)this.albumManager.create(album));
        Track track = new Track();
        track.name = "tr";
        EntityTestCase.assertFalse((boolean)this.trackManager.create(track));
        track.album = album;
        EntityTestCase.assertTrue((boolean)this.trackManager.create(track));
        Album album2 = new Album();
        album2.name = "name2";
        track.nullableAlbum = album2;
        EntityTestCase.assertTrue((boolean)this.trackManager.update(track));
        EntityTestCase.assertFalse((track.nullableAlbum.id == 0L ? 1 : 0) != 0);
        album.name = null;
        EntityTestCase.assertFalse((boolean)this.albumManager.update(album));
        track.nullableAlbum = null;
        EntityTestCase.assertTrue((boolean)this.trackManager.update(track));
        EntityTestCase.assertNull((Object)((Object)((Track)this.trackManager.read((long)track.id)).nullableAlbum));
    }

    public void testOffsetLimit() {
        int count = 100;
        int offset = 10;
        int limit = 20;
        this.createAlbums(count);
        EntityTestCase.assertEquals((int)count, (int)this.albumManager.select().count());
        EntityTestCase.assertEquals((int)limit, (int)this.albumManager.select().limit(limit).count());
        EntityTestCase.assertEquals((int)limit, (int)this.albumManager.select().offset(offset).limit(limit).count());
        EntityTestCase.assertEquals((int)(count - offset), (int)this.albumManager.select().offset(offset).count());
    }

    public void testWhere() {
        Album album = this.createAlbum();
        EntityTestCase.assertEquals((int)1, (int)this.albumManager.select().where("_id = ?", new Object[]{album.id}).count());
        EntityTestCase.assertEquals((int)1, (int)this.albumManager.select().where("_id = " + album.id, new Object[0]).count());
    }

    public void testM2M() {
        Album album = this.createAlbum();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String name : TAGS) {
            tags.add(new Tag(name));
        }
        this.albumManager.addTags(album.id, tags);
        EntityTestCase.assertEquals((int)TAGS.length, (int)this.albumToTagManager.select().count());
        tags = this.albumManager.getTags(album.id);
        EntityTestCase.assertEquals((int)TAGS.length, (int)tags.size());
        this.tagManager.delete(tags);
        tags = this.albumManager.getTags(album.id);
        EntityTestCase.assertEquals((int)0, (int)this.albumToTagManager.select().count());
        EntityTestCase.assertEquals((int)0, (int)tags.size());
    }

    private Album createAlbum() {
        Album album = new Album(ALBUMS[0], YEARS[0]);
        this.albumManager.create(album);
        return album;
    }

    private int createAlbums(int count) {
        ArrayList<Album> albums = new ArrayList<Album>();
        for (int i = 0; i < count; ++i) {
            albums.add(new Album("A " + i, i));
        }
        return this.albumManager.create(albums);
    }
}

