/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.test.testcase;

import android.test.AndroidTestCase;
import org.droidparts.net.http.HTTPException;
import org.droidparts.net.http.HTTPResponse;
import org.droidparts.net.http.RESTClient;
import org.droidparts.net.http.RESTClient2;

public class RESTClientTestCase
extends AndroidTestCase {
    private static final String AUTH_URL = "http://www.httpwatch.com/httpgallery/authentication/authenticatedimage/default.aspx";
    private static final String AUTH_LOGIN = "httpwatch";

    public void _testHttpBasicAuth() {
        RESTClient2 client = new RESTClient2(this.getContext());
        this.testUnauthenticated((RESTClient)client);
        this.testAuthenticatedWrongCredentials((RESTClient)client);
        this.testAuthenticated((RESTClient)client);
    }

    public void _testHttpBasicAuthLegacy() {
        RESTClient2 client = new RESTClient2(this.getContext(), RESTClient.getUserAgent(null), true);
        this.testUnauthenticated((RESTClient)client);
        this.testAuthenticatedWrongCredentials((RESTClient)client);
        this.testAuthenticated((RESTClient)client);
    }

    private void testUnauthenticated(RESTClient client) {
        try {
            HTTPResponse resp = client.get(AUTH_URL);
            RESTClientTestCase.assertNull((Object)resp);
        }
        catch (HTTPException e) {
            RESTClientTestCase.assertEquals((int)401, (int)e.getResponseCode());
        }
    }

    private void testAuthenticatedWrongCredentials(RESTClient client) {
        client.authenticateBasic("wtf", AUTH_LOGIN);
        try {
            HTTPResponse resp = client.get(AUTH_URL);
            RESTClientTestCase.assertNull((Object)resp);
        }
        catch (HTTPException e) {
            RESTClientTestCase.assertEquals((int)401, (int)e.getResponseCode());
        }
    }

    private void testAuthenticated(RESTClient client) {
        client.authenticateBasic(AUTH_LOGIN, AUTH_LOGIN);
        try {
            HTTPResponse resp = client.get(AUTH_URL);
            RESTClientTestCase.assertNotNull((Object)resp);
        }
        catch (HTTPException e) {
            RESTClientTestCase.assertNull((Object)((Object)e));
        }
    }
}

