/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql.packet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.PacketFetcher;
import org.drizzle.jdbc.internal.common.ValueObject;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.Reader;
import org.drizzle.jdbc.internal.mysql.MySQLValueObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLRowPacket {
    private final List<ValueObject> columns;
    private final Reader reader;
    private final List<ColumnInformation> columnInformation;

    public MySQLRowPacket(RawPacket rawPacket, List<ColumnInformation> columnInformation) throws IOException {
        this.columns = new ArrayList<ValueObject>(columnInformation.size());
        this.reader = new Reader(rawPacket);
        this.columnInformation = columnInformation;
    }

    public boolean isPacketComplete() throws IOException {
        long remaining;
        long encLength = this.reader.getSilentLengthEncodedBinary();
        return encLength <= (remaining = (long)this.reader.getRemainingSize());
    }

    public void appendPacket(RawPacket rawPacket) {
        this.reader.appendPacket(rawPacket);
    }

    public List<ValueObject> getRow(PacketFetcher packetFetcher) throws IOException {
        for (ColumnInformation currentColumn : this.columnInformation) {
            if (!this.isPacketComplete()) {
                this.appendPacket(packetFetcher.getRawPacket());
            }
            MySQLValueObject dvo = new MySQLValueObject(this.reader.getLengthEncodedBytes(), currentColumn.getType());
            this.columns.add(dvo);
            currentColumn.updateDisplaySize(dvo.getDisplayLength());
        }
        return this.columns;
    }
}

