/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.queryresults;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.ValueObject;
import org.drizzle.jdbc.internal.common.queryresults.NoSuchColumnException;
import org.drizzle.jdbc.internal.common.queryresults.ResultSetType;
import org.drizzle.jdbc.internal.common.queryresults.SelectQueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DrizzleQueryResult
implements SelectQueryResult {
    private final List<ColumnInformation> columnInformation;
    private final List<List<ValueObject>> resultSet;
    private final Map<String, Integer> columnNameMap;
    private final short warningCount;
    private int rowPointer;

    public DrizzleQueryResult(List<ColumnInformation> columnInformation, List<List<ValueObject>> valueObjects, short warningCount) {
        this.columnInformation = columnInformation;
        this.resultSet = valueObjects;
        this.warningCount = warningCount;
        this.columnNameMap = new HashMap<String, Integer>();
        this.rowPointer = -1;
        int i = 0;
        for (ColumnInformation ci : columnInformation) {
            this.columnNameMap.put(ci.getTable().toLowerCase() + "." + ci.getName().toLowerCase(), i);
            this.columnNameMap.put(ci.getName().toLowerCase(), i++);
        }
    }

    @Override
    public boolean next() {
        ++this.rowPointer;
        return this.rowPointer < this.resultSet.size();
    }

    @Override
    public void close() {
        this.columnInformation.clear();
        this.resultSet.clear();
        this.columnNameMap.clear();
    }

    @Override
    public short getWarnings() {
        return this.warningCount;
    }

    @Override
    public String getMessage() {
        return null;
    }

    @Override
    public List<ColumnInformation> getColumnInformation() {
        return this.columnInformation;
    }

    @Override
    public ValueObject getValueObject(int i) throws NoSuchColumnException {
        if (i < 0 || i > this.resultSet.get(this.rowPointer).size()) {
            throw new NoSuchColumnException("No such column: " + i);
        }
        return this.resultSet.get(this.rowPointer).get(i);
    }

    @Override
    public ValueObject getValueObject(String column) throws NoSuchColumnException {
        if (this.columnNameMap.get(column.toLowerCase()) == null) {
            throw new NoSuchColumnException("No such column: " + column);
        }
        return this.getValueObject(this.columnNameMap.get(column.toLowerCase()));
    }

    @Override
    public int getRows() {
        return this.resultSet.size();
    }

    @Override
    public int getColumnId(String columnLabel) throws NoSuchColumnException {
        if (this.columnNameMap.get(columnLabel.toLowerCase()) == null) {
            throw new NoSuchColumnException("No such column: " + columnLabel);
        }
        return this.columnNameMap.get(columnLabel.toLowerCase());
    }

    @Override
    public void moveRowPointerTo(int i) {
        this.rowPointer = i;
    }

    @Override
    public int getRowPointer() {
        return this.rowPointer;
    }

    @Override
    public ResultSetType getResultSetType() {
        return ResultSetType.SELECT;
    }
}

