/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.OutputStream;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class ByteParameter
implements ParameterHolder {
    private final byte[] buffer;
    private final int length;

    public ByteParameter(byte[] x) {
        this.buffer = new byte[x.length * 2 + 2];
        int pos = 0;
        this.buffer[pos++] = 39;
        for (byte b : x) {
            if (Utils.needsEscaping(b)) {
                this.buffer[pos++] = 92;
            }
            this.buffer[pos++] = b;
        }
        this.buffer[pos++] = 39;
        this.length = pos;
    }

    public int writeTo(OutputStream os, int offset, int maxWriteSize) throws IOException {
        int bytesToWrite = Math.min(this.length - offset, maxWriteSize);
        os.write(this.buffer, offset, bytesToWrite);
        return bytesToWrite;
    }

    public long length() {
        return this.length;
    }
}

