/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drizzle.jdbc.internal.common.HttpClient;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class BlobStreamingParameter
implements ParameterHolder {
    private String blobReference = null;
    private final InputStream blobStream;
    private final HttpClient httpClient;

    public BlobStreamingParameter(InputStream is, String host, String port, String schema) throws IOException {
        this.blobStream = is;
        this.httpClient = new HttpClient("http://" + host + ":" + port + "/" + schema);
    }

    public final int writeTo(OutputStream os, int offset, int maxWriteSize) throws IOException {
        int bytesToWrite = Math.min(this.blobReference.getBytes().length - offset, maxWriteSize);
        os.write(this.blobReference.getBytes(), offset, this.blobReference.getBytes().length);
        return bytesToWrite;
    }

    public final long length() throws IOException {
        this.blobReference = "\"" + this.httpClient.put(this.blobStream) + "\"";
        return this.blobReference.getBytes().length;
    }
}

