/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.drizzle.jdbc.internal.common.query.Query;
import org.drizzle.jdbc.internal.common.query.QueryType;

public class DrizzleQuery
implements Query {
    private final String query;
    private final byte[] queryToSend;

    public DrizzleQuery(String query) {
        this.query = query;
        try {
            this.queryToSend = query.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + e.getMessage(), e);
        }
    }

    public DrizzleQuery(byte[] query) {
        this.queryToSend = query;
        try {
            this.query = new String(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + e.getMessage(), e);
        }
    }

    public int length() {
        return this.queryToSend.length;
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.queryToSend, 0, this.queryToSend.length);
    }

    public String getQuery() {
        return this.query;
    }

    public QueryType getQueryType() {
        return QueryType.classifyQuery(this.query);
    }

    public boolean equals(Object otherObj) {
        return otherObj instanceof DrizzleQuery && ((DrizzleQuery)otherObj).query.equals(this.query);
    }

    public void writeTo(OutputStream ostream, int offset, int packLength) throws IOException {
        ostream.write(this.queryToSend, offset, packLength);
    }
}

