/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.drizzle.jdbc.internal.common.PacketFetcher;
import org.drizzle.jdbc.internal.common.packet.RawPacket;

public class SyncPacketFetcher
implements PacketFetcher {
    private final InputStream inputStream;

    public SyncPacketFetcher(InputStream is) {
        this.inputStream = new BufferedInputStream(is);
    }

    public RawPacket getRawPacket() throws IOException {
        return RawPacket.nextPacket(this.inputStream);
    }

    public void clearInputStream() throws IOException {
        int available = this.inputStream.available();
        while (available > 0) {
            available = (int)((long)available - this.inputStream.skip(available));
        }
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

