/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet;

import java.io.IOException;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.ResultPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.Reader;

public class ErrorPacket
extends ResultPacket {
    private final short errorNumber;
    private final byte sqlStateMarker;
    private final byte[] sqlState;
    private final String message;

    public ErrorPacket(RawPacket rawPacket) throws IOException {
        Reader reader = new Reader(rawPacket);
        reader.readByte();
        this.errorNumber = reader.readShort();
        this.sqlStateMarker = reader.readByte();
        this.sqlState = reader.readRawBytes(5);
        this.message = reader.readString("UTF-8");
    }

    public String getMessage() {
        return this.message;
    }

    public ResultPacket.ResultType getResultType() {
        return ResultPacket.ResultType.ERROR;
    }

    public byte getPacketSeq() {
        return 0;
    }

    public short getErrorNumber() {
        return this.errorNumber;
    }

    public String getSqlState() {
        return new String(this.sqlState);
    }

    public byte getSqlStateMarker() {
        return this.sqlStateMarker;
    }
}

