/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import org.drizzle.jdbc.internal.SQLExceptionMapper;
import org.drizzle.jdbc.internal.common.BinlogDumpException;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.PacketFetcher;
import org.drizzle.jdbc.internal.common.Protocol;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.SupportedDatabases;
import org.drizzle.jdbc.internal.common.ValueObject;
import org.drizzle.jdbc.internal.common.packet.EOFPacket;
import org.drizzle.jdbc.internal.common.packet.ErrorPacket;
import org.drizzle.jdbc.internal.common.packet.OKPacket;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.ResultPacket;
import org.drizzle.jdbc.internal.common.packet.ResultPacketFactory;
import org.drizzle.jdbc.internal.common.packet.ResultSetPacket;
import org.drizzle.jdbc.internal.common.packet.SyncPacketFetcher;
import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;
import org.drizzle.jdbc.internal.common.packet.commands.ClosePacket;
import org.drizzle.jdbc.internal.common.packet.commands.SelectDBPacket;
import org.drizzle.jdbc.internal.common.packet.commands.StreamedQueryPacket;
import org.drizzle.jdbc.internal.common.query.DrizzleQuery;
import org.drizzle.jdbc.internal.common.query.Query;
import org.drizzle.jdbc.internal.common.queryresults.DrizzleQueryResult;
import org.drizzle.jdbc.internal.common.queryresults.DrizzleUpdateResult;
import org.drizzle.jdbc.internal.common.queryresults.QueryResult;
import org.drizzle.jdbc.internal.mysql.MySQLServerCapabilities;
import org.drizzle.jdbc.internal.mysql.packet.MySQLFieldPacket;
import org.drizzle.jdbc.internal.mysql.packet.MySQLGreetingReadPacket;
import org.drizzle.jdbc.internal.mysql.packet.MySQLRowPacket;
import org.drizzle.jdbc.internal.mysql.packet.commands.MySQLBinlogDumpPacket;
import org.drizzle.jdbc.internal.mysql.packet.commands.MySQLClientAuthPacket;
import org.drizzle.jdbc.internal.mysql.packet.commands.MySQLPingPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLProtocol
implements Protocol {
    private static final Logger log = Logger.getLogger(MySQLProtocol.class.getName());
    private boolean connected = false;
    private final Socket socket;
    private final BufferedOutputStream writer;
    private final String version;
    private boolean readOnly = false;
    private final String host;
    private final int port;
    private String database;
    private final String username;
    private final String password;
    private final List<Query> batchList;
    private final PacketFetcher packetFetcher;

    public MySQLProtocol(String host, int port, String database, String username, String password) throws QueryException {
        this.host = host;
        this.port = port;
        this.database = database == null ? "" : database;
        this.username = username == null ? "" : username;
        this.password = password == null ? "" : password;
        SocketFactory socketFactory = SocketFactory.getDefault();
        try {
            this.socket = socketFactory.createSocket(host, port);
        }
        catch (IOException e) {
            throw new QueryException("Could not connect: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        this.batchList = new ArrayList<Query>();
        try {
            BufferedInputStream reader = new BufferedInputStream(this.socket.getInputStream(), 32768);
            this.packetFetcher = new SyncPacketFetcher(reader);
            this.writer = new BufferedOutputStream(this.socket.getOutputStream(), 32768);
            MySQLGreetingReadPacket greetingPacket = new MySQLGreetingReadPacket(this.packetFetcher.getRawPacket());
            log.finest("Got greeting packet");
            this.version = greetingPacket.getServerVersion();
            EnumSet<MySQLServerCapabilities[]> capabilities = EnumSet.of(MySQLServerCapabilities.LONG_PASSWORD, new MySQLServerCapabilities[]{MySQLServerCapabilities.CONNECT_WITH_DB, MySQLServerCapabilities.IGNORE_SPACE, MySQLServerCapabilities.CLIENT_PROTOCOL_41, MySQLServerCapabilities.TRANSACTIONS, MySQLServerCapabilities.SECURE_CONNECTION});
            MySQLClientAuthPacket cap = new MySQLClientAuthPacket(this.username, this.password, this.database, capabilities, greetingPacket.getSeed());
            cap.send(this.writer);
            log.finest("Sending auth packet");
            RawPacket rp = this.packetFetcher.getRawPacket();
            ResultPacket resultPacket = ResultPacketFactory.createResultPacket(rp);
            if (resultPacket.getResultType() == ResultPacket.ResultType.ERROR) {
                ErrorPacket ep = (ErrorPacket)resultPacket;
                String message = ep.getMessage();
                throw new QueryException("Could not connect: " + message);
            }
            this.connected = true;
        }
        catch (IOException e) {
            throw new QueryException("Could not connect: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public void close() throws QueryException {
        try {
            ClosePacket closePacket = new ClosePacket();
            closePacket.send(this.writer);
            this.writer.close();
            this.packetFetcher.close();
        }
        catch (IOException e) {
            throw new QueryException("Could not close connection: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            try {
                this.connected = false;
                this.socket.close();
            }
            catch (IOException e) {
                log.warning("Could not close socket");
            }
        }
        this.connected = false;
    }

    @Override
    public boolean isClosed() {
        return !this.connected;
    }

    private QueryResult createDrizzleQueryResult(ResultSetPacket packet) throws IOException {
        RawPacket rawPacket;
        ArrayList<ColumnInformation> columnInformation = new ArrayList<ColumnInformation>();
        int i = 0;
        while ((long)i < packet.getFieldCount()) {
            rawPacket = this.packetFetcher.getRawPacket();
            ColumnInformation columnInfo = MySQLFieldPacket.columnInformationFactory(rawPacket);
            columnInformation.add(columnInfo);
            ++i;
        }
        this.packetFetcher.getRawPacket();
        ArrayList<List<ValueObject>> valueObjects = new ArrayList<List<ValueObject>>();
        while (true) {
            if (ReadUtil.eofIsNext(rawPacket = this.packetFetcher.getRawPacket())) {
                EOFPacket eofPacket = (EOFPacket)ResultPacketFactory.createResultPacket(rawPacket);
                return new DrizzleQueryResult(columnInformation, valueObjects, eofPacket.getWarningCount());
            }
            MySQLRowPacket rowPacket = new MySQLRowPacket(rawPacket, columnInformation);
            valueObjects.add(rowPacket.getRow());
        }
    }

    @Override
    public void selectDB(String database) throws QueryException {
        log.finest("Selecting db " + database);
        SelectDBPacket packet = new SelectDBPacket(database);
        try {
            packet.send(this.writer);
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            ResultPacketFactory.createResultPacket(rawPacket);
        }
        catch (IOException e) {
            throw new QueryException("Could not select database: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        this.database = database;
    }

    @Override
    public String getServerVersion() {
        return this.version;
    }

    @Override
    public void setReadonly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean getReadonly() {
        return this.readOnly;
    }

    @Override
    public void commit() throws QueryException {
        log.finest("commiting transaction");
        this.executeQuery(new DrizzleQuery("COMMIT"));
    }

    @Override
    public void rollback() throws QueryException {
        log.finest("rolling transaction back");
        this.executeQuery(new DrizzleQuery("ROLLBACK"));
    }

    @Override
    public void rollback(String savepoint) throws QueryException {
        log.finest("rolling back to savepoint " + savepoint);
        this.executeQuery(new DrizzleQuery("ROLLBACK TO SAVEPOINT " + savepoint));
    }

    @Override
    public void setSavepoint(String savepoint) throws QueryException {
        this.executeQuery(new DrizzleQuery("SAVEPOINT " + savepoint));
    }

    @Override
    public void releaseSavepoint(String savepoint) throws QueryException {
        this.executeQuery(new DrizzleQuery("RELEASE SAVEPOINT " + savepoint));
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean ping() throws QueryException {
        MySQLPingPacket pingPacket = new MySQLPingPacket();
        try {
            pingPacket.send(this.writer);
            log.finest("Sent ping packet");
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            return ResultPacketFactory.createResultPacket(rawPacket).getResultType() == ResultPacket.ResultType.OK;
        }
        catch (IOException e) {
            throw new QueryException("Could not ping: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public QueryResult executeQuery(Query dQuery) throws QueryException {
        ResultPacket resultPacket;
        log.finest("Executing streamed query: " + dQuery);
        StreamedQueryPacket packet = new StreamedQueryPacket(dQuery);
        try {
            packet.send(this.writer);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        try {
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            resultPacket = ResultPacketFactory.createResultPacket(rawPacket);
        }
        catch (IOException e) {
            throw new QueryException("Could not read resultset: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        switch (resultPacket.getResultType()) {
            case ERROR: {
                ErrorPacket ep = (ErrorPacket)resultPacket;
                log.warning("Could not execute query " + dQuery + ": " + ((ErrorPacket)resultPacket).getMessage());
                throw new QueryException(ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            case OK: {
                OKPacket okpacket = (OKPacket)resultPacket;
                DrizzleUpdateResult updateResult = new DrizzleUpdateResult(okpacket.getAffectedRows(), okpacket.getWarnings(), okpacket.getMessage(), okpacket.getInsertId());
                log.fine("OK, " + okpacket.getAffectedRows());
                return updateResult;
            }
            case RESULTSET: {
                log.fine("SELECT executed, fetching result set");
                try {
                    return this.createDrizzleQueryResult((ResultSetPacket)resultPacket);
                }
                catch (IOException e) {
                    throw new QueryException("Could not read result set: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
        }
        log.severe("Could not parse result...");
        throw new QueryException("Could not parse result");
    }

    @Override
    public void addToBatch(Query dQuery) {
        this.batchList.add(dQuery);
    }

    @Override
    public List<QueryResult> executeBatch() throws QueryException {
        ArrayList<QueryResult> retList = new ArrayList<QueryResult>(this.batchList.size());
        for (Query query : this.batchList) {
            retList.add(this.executeQuery(query));
        }
        this.clearBatch();
        return retList;
    }

    @Override
    public void clearBatch() {
        this.batchList.clear();
    }

    @Override
    public List<RawPacket> startBinlogDump(int startPos, String filename) throws BinlogDumpException {
        MySQLBinlogDumpPacket mbdp = new MySQLBinlogDumpPacket(startPos, filename);
        try {
            mbdp.send(this.writer);
            LinkedList<RawPacket> rpList = new LinkedList<RawPacket>();
            while (true) {
                RawPacket rp;
                if (ReadUtil.eofIsNext(rp = this.packetFetcher.getRawPacket())) {
                    return rpList;
                }
                rpList.add(rp);
            }
        }
        catch (IOException e) {
            throw new BinlogDumpException("Could not read binlog", e);
        }
    }

    @Override
    public SupportedDatabases getDatabaseType() {
        return SupportedDatabases.MYSQL;
    }
}

