/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.drizzle.jdbc.internal.common.query.Query;
import org.drizzle.jdbc.internal.common.query.QueryType;

public class DrizzleQuery
implements Query {
    private static final Logger log = Logger.getLogger(DrizzleQuery.class.getName());
    private final String query;
    private final byte[] queryToSend;

    public DrizzleQuery(String query) {
        this.query = query;
        this.queryToSend = query.getBytes();
    }

    public int length() {
        return this.queryToSend.length;
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.queryToSend, 0, this.queryToSend.length);
    }

    public String getQuery() {
        return this.query;
    }

    public QueryType getQueryType() {
        return QueryType.classifyQuery(this.query);
    }

    public boolean equals(Object otherObj) {
        return otherObj instanceof DrizzleQuery && ((DrizzleQuery)otherObj).query.equals(this.query);
    }
}

