/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet;

import java.io.IOException;
import java.util.Set;
import org.drizzle.jdbc.internal.common.ServerStatus;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.ResultPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.Reader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OKPacket
extends ResultPacket {
    private final byte fieldCount;
    private final long affectedRows;
    private final long insertId;
    private final Set<ServerStatus> serverStatus;
    private final short warnings;
    private final String message;
    private final byte packetSeqNum;

    public OKPacket(RawPacket rawPacket) throws IOException {
        Reader reader = new Reader(rawPacket);
        this.packetSeqNum = 0;
        this.fieldCount = reader.readByte();
        this.affectedRows = reader.getLengthEncodedBinary();
        this.insertId = reader.getLengthEncodedBinary();
        this.serverStatus = ServerStatus.getServerStatusSet(reader.readShort());
        this.warnings = reader.readShort();
        this.message = new String(reader.getLengthEncodedBytes());
    }

    @Override
    public ResultPacket.ResultType getResultType() {
        return ResultPacket.ResultType.OK;
    }

    @Override
    public byte getPacketSeq() {
        return this.packetSeqNum;
    }

    public String toString() {
        return "affectedRows = " + this.affectedRows + "&insertId = " + this.insertId + "&serverStatus=" + this.serverStatus + "&warnings=" + this.warnings + "&message=" + this.message;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getInsertId() {
        return this.insertId;
    }

    public Set<ServerStatus> getServerStatus() {
        return this.serverStatus;
    }

    public short getWarnings() {
        return this.warnings;
    }

    public String getMessage() {
        return this.message;
    }
}

