/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final int START_BIT_MILLISECONDS = 17;
    private static final int START_BIT_SECONDS = 11;
    private static final int START_BIT_MINUTES = 5;
    private static final int MASK_HOURS = 31;
    private static final int MASK_MINUTES = 2016;
    private static final int MASK_SECONDS = 129024;
    private static final int MASK_MILLISECONDS = -131072;

    public static boolean needsEscaping(byte b) {
        if ((b & 0x80) == 0) {
            switch (b) {
                case 0: 
                case 10: 
                case 13: 
                case 26: 
                case 34: 
                case 39: 
                case 92: {
                    return true;
                }
            }
        }
        return false;
    }

    public static String sqlEscapeString(String str) {
        byte[] strBytes = str.getBytes();
        byte[] outBytes = new byte[strBytes.length * 2];
        int bytePointer = 0;
        boolean neededEscaping = false;
        for (byte b : strBytes) {
            if (Utils.needsEscaping(b)) {
                neededEscaping = true;
                outBytes[bytePointer++] = 92;
                outBytes[bytePointer++] = b;
                continue;
            }
            outBytes[bytePointer++] = b;
        }
        if (neededEscaping) {
            return new String(outBytes, 0, bytePointer);
        }
        return str;
    }

    public static int countChars(String str, char c) {
        int count = 0;
        boolean isWithinDoubleQuotes = false;
        boolean isWithinQuotes = false;
        for (byte b : str.getBytes()) {
            if (b == 34 && !isWithinQuotes && !isWithinDoubleQuotes) {
                isWithinDoubleQuotes = true;
            } else if (b == 34 && !isWithinQuotes) {
                isWithinDoubleQuotes = false;
            }
            if (b == 39 && !isWithinQuotes && !isWithinDoubleQuotes) {
                isWithinQuotes = true;
            } else if (b == 39 && !isWithinDoubleQuotes) {
                isWithinQuotes = false;
            }
            if (isWithinDoubleQuotes || isWithinQuotes || c != b) continue;
            ++count;
        }
        return count;
    }

    public static List<String> createQueryParts(String query) {
        boolean isWithinDoubleQuotes = false;
        boolean isWithinQuotes = false;
        int queryPos = 0;
        int lastQueryPos = 0;
        LinkedList<String> queryParts = new LinkedList<String>();
        for (byte b : query.getBytes()) {
            if (b == 34 && !isWithinQuotes && !isWithinDoubleQuotes) {
                isWithinDoubleQuotes = true;
            } else if (b == 34 && !isWithinQuotes) {
                isWithinDoubleQuotes = false;
            }
            if (b == 39 && !isWithinQuotes && !isWithinDoubleQuotes) {
                isWithinQuotes = true;
            } else if (b == 39 && !isWithinDoubleQuotes) {
                isWithinQuotes = false;
            }
            if (!isWithinDoubleQuotes && !isWithinQuotes && b == 63) {
                queryParts.add(query.substring(lastQueryPos, queryPos));
                lastQueryPos = queryPos + 1;
            }
            ++queryPos;
        }
        queryParts.add(query.substring(lastQueryPos, queryPos));
        return queryParts;
    }

    public static String stripQuery(String query) {
        StringBuilder sb = new StringBuilder();
        ParsingState parsingState = ParsingState.NORMAL;
        ParsingState nextParsingState = ParsingState.NORMAL;
        for (int i = 0; i < query.length(); ++i) {
            int b = query.codePointAt(i);
            int nextCodePoint = 0;
            if (i < query.length() - 1) {
                nextCodePoint = query.codePointAt(i + 1);
            }
            switch (parsingState) {
                case WITHIN_DOUBLE_QUOTES: {
                    if (b != 34) break;
                    nextParsingState = ParsingState.NORMAL;
                    break;
                }
                case WITHIN_QUOTES: {
                    if (b != 39) break;
                    nextParsingState = ParsingState.NORMAL;
                    break;
                }
                case NORMAL: {
                    if (b == 39) {
                        nextParsingState = ParsingState.WITHIN_QUOTES;
                        break;
                    }
                    if (b == 34) {
                        nextParsingState = ParsingState.WITHIN_DOUBLE_QUOTES;
                        break;
                    }
                    if (b == 47 && nextCodePoint == 42) {
                        nextParsingState = ParsingState.WITHIN_COMMENT;
                        parsingState = ParsingState.WITHIN_COMMENT;
                        break;
                    }
                    if (b != 35) break;
                    return sb.toString();
                }
                case WITHIN_COMMENT: {
                    if (b != 42 || nextCodePoint != 47) break;
                    nextParsingState = ParsingState.NORMAL;
                    ++i;
                }
            }
            if (parsingState != ParsingState.WITHIN_COMMENT) {
                sb.append((char)b);
            }
            parsingState = nextParsingState;
        }
        return sb.toString();
    }

    public static byte[] encryptPassword(String password, byte[] seed) throws NoSuchAlgorithmException {
        if (password == null || password.equals("")) {
            return new byte[0];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] stage1 = messageDigest.digest(password.getBytes());
        messageDigest.reset();
        byte[] stage2 = messageDigest.digest(stage1);
        messageDigest.reset();
        messageDigest.update(seed);
        messageDigest.update(stage2);
        byte[] digest = messageDigest.digest();
        byte[] returnBytes = new byte[digest.length];
        for (int i = 0; i < digest.length; ++i) {
            returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
        }
        return returnBytes;
    }

    public static int packTime(long milliseconds) {
        int millis = (int)(milliseconds % 1000L);
        int seconds = (int)(milliseconds / 1000L % 60L);
        int minutes = (int)(milliseconds / 60000L % 60L);
        int hours = (int)(milliseconds / 3600000L % 24L);
        return millis * 131072 + seconds * 2048 + minutes * 32 + hours;
    }

    public static long unpackTime(int packedTime) {
        int hours = packedTime & 0x1F;
        int minutes = (packedTime & 0x7E0) >> 5;
        int seconds = (packedTime & 0x1F800) >> 11;
        int millis = (packedTime & 0xFFFE0000) >> 17;
        long returnValue = (long)hours * 60L * 60L * 1000L;
        returnValue += (long)minutes * 60L * 1000L;
        returnValue += (long)seconds * 1000L;
        return returnValue += (long)millis;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParsingState {
        WITHIN_COMMENT,
        WITHIN_QUOTES,
        WITHIN_DOUBLE_QUOTES,
        NORMAL;

    }
}

