/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLWarning;
import org.drizzle.jdbc.internal.common.QueryException;

public class SQLExceptionMapper {
    public static SQLException get(QueryException e) {
        String sqlState = e.getSqlState();
        SQLStates state = SQLStates.fromString(sqlState);
        switch (state) {
            case DATA_EXCEPTION: {
                return new SQLDataException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case FEATURE_NOT_SUPPORTED: {
                return new SQLFeatureNotSupportedException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case CONSTRAINT_VIOLATION: {
                return new SQLIntegrityConstraintViolationException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case INVALID_AUTHORIZATION: {
                return new SQLInvalidAuthorizationSpecException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case CONNECTION_EXCEPTION: {
                return new SQLNonTransientConnectionException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case SYNTAX_ERROR_ACCESS_RULE: {
                return new SQLSyntaxErrorException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case TRANSACTION_ROLLBACK: {
                return new SQLTransactionRollbackException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case WARNING: {
                return new SQLWarning(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
        }
        return new SQLException(e.getMessage(), sqlState, e.getErrorCode(), e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SQLStates {
        WARNING("01"),
        NO_DATA("02"),
        CONNECTION_EXCEPTION("08"),
        FEATURE_NOT_SUPPORTED("0A"),
        CARDINALITY_VIOLATION("21"),
        DATA_EXCEPTION("22"),
        CONSTRAINT_VIOLATION("23"),
        INVALID_CURSOR_STATE("24"),
        INVALID_TRANSACTION_STATE("25"),
        INVALID_AUTHORIZATION("28"),
        SQL_FUNCTION_EXCEPTION("2F"),
        TRANSACTION_ROLLBACK("40"),
        SYNTAX_ERROR_ACCESS_RULE("42"),
        INVALID_CATALOG("3D"),
        INTERRUPTED_EXCEPTION("70"),
        UNDEFINED_SQLSTATE("HY"),
        DISTRIBUTED_TRANSACTION_ERROR("XA");

        private final String sqlStateGroup;

        private SQLStates(String s) {
            this.sqlStateGroup = s;
        }

        public static SQLStates fromString(String group) {
            for (SQLStates state : SQLStates.values()) {
                if (!group.startsWith(state.sqlStateGroup)) continue;
                return state;
            }
            return UNDEFINED_SQLSTATE;
        }

        public String getSqlState() {
            return this.sqlStateGroup;
        }
    }
}

