/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.drizzle.jdbc.DrizzleConnection;
import org.drizzle.jdbc.JDBCUrl;
import org.drizzle.jdbc.internal.SQLExceptionMapper;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.query.DrizzleQueryFactory;
import org.drizzle.jdbc.internal.mysql.MySQLProtocol;

public final class DrizzleDriver
implements Driver {
    private static final Logger log = Logger.getLogger(DrizzleDriver.class.getName());

    public Connection connect(String url, Properties info) throws SQLException {
        log.finest("Connecting to: " + url);
        try {
            JDBCUrl jdbcUrl = JDBCUrl.parse(url);
            if (jdbcUrl == null) {
                return null;
            }
            String userName = info.getProperty("user", jdbcUrl.getUsername());
            String password = info.getProperty("password", jdbcUrl.getPassword());
            MySQLProtocol protocol = new MySQLProtocol(jdbcUrl.getHostname(), jdbcUrl.getPort(), jdbcUrl.getDatabase(), userName, password);
            return new DrizzleConnection(protocol, new DrizzleQueryFactory());
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:drizzle://") || url.startsWith("jdbc:mysql:thin://");
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new DrizzleDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register driver", e);
        }
    }
}

