/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DrizzleDatabaseMetaData
implements DatabaseMetaData {
    private final String version;
    private final String url;
    private final String username;
    private final Connection connection;
    private static final Logger log = Logger.getLogger(DrizzleDatabaseMetaData.class.getName());
    private final String databaseProductName;
    private final String dataTypeClause = " CASE data_type WHEN 'int' THEN 4 WHEN 'varchar' THEN 12 WHEN 'datetime' THEN 93 WHEN 'date' THEN 91 WHEN 'time' THEN 92 WHEN 'text' THEN 12 WHEN 'bigint' THEN -5 WHEN 'varbinary' THEN -3 WHEN 'timestamp' THEN 93 WHEN 'double' THEN 8 END";

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.url;
    }

    @Override
    public String getUserName() throws SQLException {
        return this.username;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return !this.nullsAreSortedHigh();
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return !this.nullsAreSortedAtStart();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.databaseProductName;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.version;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Drizzle-JDBC";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "0.1";
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 3;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return !this.storesUpperCaseIdentifiers();
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return !this.storesMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "`";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,LAST_INSERT_ID,VERSION";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "#@";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "database";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 256;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 256;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 32;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 256;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 16;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 4;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        log.info("getting empty result set, procedures");
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        log.info("getting empty result set, proc columns");
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String query = "SELECT table_catalog table_cat, table_schema table_schem, table_name, table_type, table_comment as remarks,null as type_cat, null as type_schem,null as type_name, null as self_referencing_col_name,null as ref_generation FROM information_schema.tables WHERE table_name LIKE \"" + (tableNamePattern == null ? "%" : tableNamePattern) + "\"" + this.getSchemaPattern(schemaPattern);
        if (types != null) {
            query = query + " AND table_type in (";
            boolean first = true;
            for (String s : types) {
                String mappedType = this.mapTableTypes(s);
                if (!first) {
                    query = query + ",";
                }
                first = false;
                query = query + "'" + mappedType + "'";
            }
            query = query + ")";
        }
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(query);
    }

    private String getSchemaPattern(String schemaPattern) {
        if (schemaPattern != null) {
            return " AND table_schema LIKE \"" + schemaPattern + "\"";
        }
        return " AND table_schema LIKE IFNULL(database(), \"%\")";
    }

    private String mapTableTypes(String tableType) {
        if (tableType.equals("TABLE")) {
            return "BASE TABLE";
        }
        return tableType;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery("SELECT schema_name table_schem, catalog_name table_catalog FROM information_schema.schemata");
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery("SELECT null as table_cat");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery("SELECT DISTINCT(table_type) FROM information_schema.tables");
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String query = "     SELECT null as table_cat,            table_schema as table_schem,            table_name,            column_name, CASE data_type WHEN 'int' THEN 4 WHEN 'varchar' THEN 12 WHEN 'datetime' THEN 93 WHEN 'date' THEN 91 WHEN 'time' THEN 92 WHEN 'text' THEN 12 WHEN 'bigint' THEN -5 WHEN 'varbinary' THEN -3 WHEN 'timestamp' THEN 93 WHEN 'double' THEN 8 END data_type,            data_type type_name,            character_maximum_length column_size,            0 buffer_length,            numeric_precision decimal_digits,            numeric_scale num_prec_radix,            if(is_nullable='yes',1,0) nullable,            column_comment remarks,            column_default column_def,            0 sql_data,            0 sql_datetime_sub,            character_octet_length char_octet_length,            ordinal_position,            is_nullable,            null scope_catalog,            null scope_schema,            null scope_table,            null source_data_type,            '' is_autoincrement    FROM information_schema.columns WHERE table_schema LIKE '" + (schemaPattern == null ? "%" : schemaPattern) + "'" + " AND table_name LIKE '" + (tableNamePattern == null ? "%" : tableNamePattern) + "'" + " AND column_name LIKE '" + (columnNamePattern == null ? "%" : columnNamePattern) + "'" + " ORDER BY table_cat, table_schem, table_name, ordinal_position";
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(query);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        log.info("getting empty result set, column privileges");
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Statement stmt = this.connection.createStatement();
        String query = "SELECT null table_cat, table_schema table_schem, table_name, null grantor, user() grantee, 'update' privilege, 'yes' is_grantable FROM information_schema.columns WHERE table_schema LIKE '" + (schemaPattern == null ? "%" : schemaPattern) + "'" + " AND table_name LIKE '" + (tableNamePattern == null ? "%" : tableNamePattern) + "'";
        return stmt.executeQuery(query);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String query = "SELECT 2 scope,column_name, CASE data_type WHEN 'int' THEN 4 WHEN 'varchar' THEN 12 WHEN 'datetime' THEN 93 WHEN 'date' THEN 91 WHEN 'time' THEN 92 WHEN 'text' THEN 12 WHEN 'bigint' THEN -5 WHEN 'varbinary' THEN -3 WHEN 'timestamp' THEN 93 WHEN 'double' THEN 8 END data_type,data_type type_name,if(numeric_precision is null, character_maximum_length, numeric_precision) column_size,0 buffer_length,numeric_scale decimal_digits,1 pseudo_column FROM information_schema.columns WHERE column_key in('PRI', 'MUL', 'UNI')  AND table_schema like " + (schema != null ? "'%'" : "'" + schema + "'") + " AND table_name='" + table + "' ORDER BY scope";
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(query);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        log.info("getting empty result set, version columns");
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT table_catalog TABLE_CAT, table_schema TABLE_SCHEM, table_name, column_name, ordinal_position KEY_SEQ,null pk_name FROM information_schema.columns WHERE table_name='" + table + "' AND column_key='pri'";
        if (schema != null) {
            query = query + " AND table_schema = '" + schema + "'";
        }
        query = query + " ORDER BY column_name";
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(query);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT null PKTABLE_CAT, \nkcu.referenced_table_schema PKTABLE_SCHEM, \nkcu.referenced_table_name PKTABLE_NAME, \nkcu.referenced_column_name PKCOLUMN_NAME, \nnull FKTABLE_CAT, \nkcu.table_schema FKTABLE_SCHEM, \nkcu.table_name FKTABLE_NAME, \nkcu.column_name FKCOLUMN_NAME, \nkcu.position_in_unique_constraint KEY_SEQ,\nCASE update_rule \n   WHEN 'RESTRICT' THEN 1\n   WHEN 'NO ACTION' THEN 3\n   WHEN 'CASCADE' THEN 0\n   WHEN 'SET NULL' THEN 2\n   WHEN 'SET DEFAULT' THEN 4\nEND UPDATE_RULE,\nCASE delete_rule \n   WHEN 'RESTRICT' THEN 1\n   WHEN 'NO ACTION' THEN 3\n   WHEN 'CASCADE' THEN 0\n   WHEN 'SET NULL' THEN 2\n   WHEN 'SET DEFAULT' THEN 4\nEND UPDATE_RULE,\nrc.constraint_name FK_NAME,\nnull PK_NAME,\n6 DEFERRABILITY\nFROM information_schema.key_column_usage kcu\nINNER JOIN information_schema.referential_constraints rc\nON kcu.constraint_schema=rc.constraint_schema\nAND kcu.constraint_name=rc.constraint_name\nWHERE " + (schema != null ? "kcu.table_schema='" + schema + "' AND " : "") + "kcu.table_name='" + table + "'" + "ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ";
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(query);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT null PKTABLE_CAT, \nkcu.referenced_table_schema PKTABLE_SCHEM, \nkcu.referenced_table_name PKTABLE_NAME, \nkcu.referenced_column_name PKCOLUMN_NAME, \nnull FKTABLE_CAT, \nkcu.table_schema FKTABLE_SCHEM, \nkcu.table_name FKTABLE_NAME, \nkcu.column_name FKCOLUMN_NAME, \nkcu.position_in_unique_constraint KEY_SEQ,\nCASE update_rule \n   WHEN 'RESTRICT' THEN 1\n   WHEN 'NO ACTION' THEN 3\n   WHEN 'CASCADE' THEN 0\n   WHEN 'SET NULL' THEN 2\n   WHEN 'SET DEFAULT' THEN 4\nEND UPDATE_RULE,\nCASE delete_rule \n   WHEN 'RESTRICT' THEN 1\n   WHEN 'NO ACTION' THEN 3\n   WHEN 'CASCADE' THEN 0\n   WHEN 'SET NULL' THEN 2\n   WHEN 'SET DEFAULT' THEN 4\nEND UPDATE_RULE,\nrc.constraint_name FK_NAME,\nnull PK_NAME,\n6 DEFERRABILITY\nFROM information_schema.key_column_usage kcu\nINNER JOIN information_schema.referential_constraints rc\nON kcu.constraint_schema=rc.constraint_schema\nAND kcu.constraint_name=rc.constraint_name\nWHERE " + (schema != null ? "kcu.referenced_table_schema='" + schema + "' AND " : "") + "kcu.referenced_table_name='" + table + "'" + "ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ";
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(query);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        log.info("getting empty result set, cross ref");
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        log.info("getting empty result set, type info");
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String query = "SELECT null table_cat,       table_schema table_schem,       table_name,       non_unique,       table_schema index_qualifier,       index_name,       3 type,       seq_in_index ordinal_position,       column_name,       collation asc_or_desc,       cardinality,       null as pages,       null as filter_condition FROM information_schema.statistics WHERE table_name='" + table + "' " + (schema != null ? " AND table_schema like '" + schema + "' " : "") + (unique ? " AND NON_UNIQUE = 0" : "") + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION";
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(query);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        log.info("getting empty result set, get UTDs");
        return this.getEmptyResultSet();
    }

    private ResultSet getEmptyResultSet() throws SQLException {
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery("select * from information_schema.statistics where 1=2");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        log.info("getting empty result set, get super types");
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        log.info("getting empty result set, get super tables");
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        log.info("getting empty result set, get attributes");
        return this.getEmptyResultSet();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String query = "SELECT schema_name table_schem, null table_catalog FROM information_schema.schemata " + (schemaPattern != null ? "WHERE schema_name like '" + schemaPattern + "'" : "") + " ORDER BY table_schem";
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(query);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        log.info("getting empty result set, client info properties");
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        log.info("getting empty result set, functions");
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLException("uh7");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private DrizzleDatabaseMetaData(Builder builder) {
        this.version = builder.version;
        this.url = builder.url;
        this.username = builder.username;
        this.connection = builder.connection;
        this.databaseProductName = builder.databaseProductName;
    }

    public static final class Builder {
        private String version;
        private String url;
        private String username;
        private final Connection connection;
        private String databaseProductName;

        public Builder(Connection connection) {
            this.connection = connection;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder databaseProductName(String name) {
            this.databaseProductName = name;
            return this;
        }

        public DrizzleDatabaseMetaData build() {
            return new DrizzleDatabaseMetaData(this);
        }
    }
}

