/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql.packet.commands;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.packet.CommandPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.WriteBuffer;
import org.drizzle.jdbc.internal.mysql.MySQLServerCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLClientAuthPacket
implements CommandPacket {
    private final WriteBuffer writeBuffer = new WriteBuffer();
    private final Set<MySQLServerCapabilities> serverCapabilities;
    private final String username;
    private final String password;
    private final String database;

    public MySQLClientAuthPacket(String username, String password, String database, Set<MySQLServerCapabilities> serverCapabilities, byte[] seed) {
        byte[] scrambledPassword;
        this.username = username;
        this.password = password;
        this.database = database;
        this.serverCapabilities = serverCapabilities;
        try {
            scrambledPassword = Utils.encryptPassword(password, seed);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-1, failing", e);
        }
        int packetLength = 32 + username.length() + 1 + scrambledPassword.length + 1 + database.length() + 1;
        byte serverLanguage = 45;
        this.writeBuffer.writeInt(MySQLServerCapabilities.fromSet(serverCapabilities)).writeInt(packetLength).writeByte(serverLanguage).writeBytes((byte)0, 23).writeString(username).writeByte((byte)0).writeByte((byte)scrambledPassword.length).writeByteArray(scrambledPassword).writeString(database).writeByte((byte)0);
    }

    @Override
    public void send(OutputStream os) throws IOException {
        byte[] buff;
        for (byte b : buff = this.writeBuffer.toByteArrayWithLength((byte)1)) {
            os.write(b);
        }
        os.flush();
    }
}

