/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql.packet;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Set;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.Reader;
import org.drizzle.jdbc.internal.common.queryresults.ColumnFlags;
import org.drizzle.jdbc.internal.mysql.MySQLColumnInformation;
import org.drizzle.jdbc.internal.mysql.MySQLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLFieldPacket {
    public static ColumnInformation columnInformationFactory(InputStream istream) throws IOException {
        Reader reader = new Reader(istream);
        return new MySQLColumnInformation.Builder().catalog(reader.getLengthEncodedString()).db(reader.getLengthEncodedString()).table(reader.getLengthEncodedString()).originalTable(reader.getLengthEncodedString()).name(reader.getLengthEncodedString()).originalName(reader.getLengthEncodedString()).skipMe(reader.skipBytes(1)).charsetNumber(reader.readShort()).length(reader.readInt()).type(MySQLType.fromServer(reader.readByte())).flags(MySQLFieldPacket.parseFlags(reader.readShort())).decimals(reader.readByte()).skipMe(reader.skipBytes(2)).build();
    }

    public static ColumnInformation columnInformationFactory(RawPacket rawPacket) throws IOException {
        Reader reader = new Reader(rawPacket);
        return new MySQLColumnInformation.Builder().catalog(reader.getLengthEncodedString()).db(reader.getLengthEncodedString()).table(reader.getLengthEncodedString()).originalTable(reader.getLengthEncodedString()).name(reader.getLengthEncodedString()).originalName(reader.getLengthEncodedString()).skipMe(reader.skipBytes(1)).charsetNumber(reader.readShort()).length(reader.readInt()).type(MySQLType.fromServer(reader.readByte())).flags(MySQLFieldPacket.parseFlags(reader.readShort())).decimals(reader.readByte()).skipMe(reader.skipBytes(2)).build();
    }

    private static Set<ColumnFlags> parseFlags(short i) {
        EnumSet<ColumnFlags> retFlags = EnumSet.noneOf(ColumnFlags.class);
        for (ColumnFlags fieldFlag : ColumnFlags.values()) {
            if ((i & fieldFlag.flag()) != fieldFlag.flag()) continue;
            retFlags.add(fieldFlag);
        }
        return retFlags;
    }
}

