/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import org.drizzle.jdbc.internal.common.DataType;

public class MySQLType
implements DataType {
    private final Type type;

    public MySQLType(Type type) {
        this.type = type;
    }

    public Class getJavaType() {
        return this.type.getDataType();
    }

    public int getSqlType() {
        return this.type.getSqlType();
    }

    public Type getType() {
        return this.type;
    }

    public static MySQLType fromServer(byte typeValue) {
        switch (typeValue) {
            case 0: {
                return new MySQLType(Type.DECIMAL);
            }
            case 1: {
                return new MySQLType(Type.TINY);
            }
            case 2: {
                return new MySQLType(Type.SHORT);
            }
            case 3: {
                return new MySQLType(Type.LONG);
            }
            case 4: {
                return new MySQLType(Type.FLOAT);
            }
            case 5: {
                return new MySQLType(Type.DOUBLE);
            }
            case 6: {
                return new MySQLType(Type.NULL);
            }
            case 7: {
                return new MySQLType(Type.TIMESTAMP);
            }
            case 8: {
                return new MySQLType(Type.LONGLONG);
            }
            case 9: {
                return new MySQLType(Type.INT24);
            }
            case 10: {
                return new MySQLType(Type.DATE);
            }
            case 11: {
                return new MySQLType(Type.TIME);
            }
            case 12: {
                return new MySQLType(Type.DATETIME);
            }
            case 13: {
                return new MySQLType(Type.YEAR);
            }
            case 14: {
                return new MySQLType(Type.DATE);
            }
            case 15: {
                return new MySQLType(Type.VARCHAR);
            }
            case 16: {
                return new MySQLType(Type.BIT);
            }
            case -10: {
                return new MySQLType(Type.NEWDECIMAL);
            }
            case -9: {
                return new MySQLType(Type.ENUM);
            }
            case -8: {
                return new MySQLType(Type.SET);
            }
            case -7: 
            case -6: 
            case -5: 
            case -4: {
                return new MySQLType(Type.BLOB);
            }
        }
        return new MySQLType(Type.VARCHAR);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DECIMAL(3, Double.class),
        TINY(5, Short.class),
        SHORT(5, Short.class),
        LONG(-5, Long.class),
        FLOAT(6, Float.class),
        DOUBLE(8, Double.class),
        NULL(0, null),
        TIMESTAMP(93, Long.class),
        LONGLONG(-5, Long.class),
        INT24(4, Integer.class),
        DATETIME(91, Date.class),
        DATE(91, Date.class),
        TIME(92, Time.class),
        YEAR(5, Short.class),
        BIT(-7, Byte.class),
        VARCHAR(12, String.class),
        NEWDECIMAL(3, BigDecimal.class),
        ENUM(12, String.class),
        SET(12, String.class),
        BLOB(2004, Blob.class),
        MAX(2004, Blob.class);

        private int sqlType;
        private Class<?> javaClass;

        private Type(int sqlType, Class<?> javaClass) {
            this.sqlType = sqlType;
            this.javaClass = javaClass;
        }

        public Class getDataType() {
            return this.javaClass;
        }

        public int getSqlType() {
            return this.sqlType;
        }
    }
}

