/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.drizzle.queryresults;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.PacketFetcher;
import org.drizzle.jdbc.internal.common.ValueObject;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;
import org.drizzle.jdbc.internal.common.queryresults.NoSuchColumnException;
import org.drizzle.jdbc.internal.common.queryresults.ResultSetType;
import org.drizzle.jdbc.internal.common.queryresults.SelectQueryResult;
import org.drizzle.jdbc.internal.drizzle.packet.RowPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrizzleAsyncQueryResult
implements SelectQueryResult {
    private final List<ColumnInformation> columnInformation;
    private List<ValueObject> currentRow;
    private final Map<String, Integer> columnNameMap;
    private int rowPointer;
    private final PacketFetcher packetFetcher;
    private boolean hasReadEOF = false;

    public DrizzleAsyncQueryResult(List<ColumnInformation> columnInformation, PacketFetcher packetFetcher) {
        this.columnInformation = Collections.unmodifiableList(columnInformation);
        this.packetFetcher = packetFetcher;
        this.columnNameMap = new HashMap<String, Integer>();
        this.rowPointer = -1;
        int i = 0;
        for (ColumnInformation ci : columnInformation) {
            this.columnNameMap.put(ci.getName().toLowerCase(), i++);
        }
    }

    @Override
    public boolean next() {
        RawPacket rawPacket = null;
        try {
            rawPacket = this.packetFetcher.getRawPacket();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not fetch packet", e);
        }
        if (ReadUtil.eofIsNext(rawPacket)) {
            this.hasReadEOF = true;
            return false;
        }
        RowPacket rowPacket = new RowPacket(rawPacket, this.columnInformation);
        this.currentRow = rowPacket.getRow();
        ++this.rowPointer;
        return true;
    }

    @Override
    public void close() {
        while (!this.hasReadEOF) {
            RawPacket rp = null;
            try {
                rp = this.packetFetcher.getRawPacket();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not fetch packet", e);
            }
            if (!ReadUtil.eofIsNext(rp)) continue;
            this.hasReadEOF = true;
        }
        this.columnInformation.clear();
        this.currentRow.clear();
        this.columnNameMap.clear();
    }

    @Override
    public short getWarnings() {
        return 0;
    }

    @Override
    public String getMessage() {
        return null;
    }

    @Override
    public List<ColumnInformation> getColumnInformation() {
        return this.columnInformation;
    }

    @Override
    public ValueObject getValueObject(int i) throws NoSuchColumnException {
        if (i < 0 || i > this.currentRow.size()) {
            throw new NoSuchColumnException("No such column: " + i);
        }
        return this.currentRow.get(i);
    }

    @Override
    public ValueObject getValueObject(String column) throws NoSuchColumnException {
        if (this.columnNameMap.get(column.toLowerCase()) == null) {
            throw new NoSuchColumnException("No such column: " + column);
        }
        return this.getValueObject(this.columnNameMap.get(column.toLowerCase()));
    }

    @Override
    public int getRows() {
        return -1;
    }

    @Override
    public int getColumnId(String columnLabel) throws NoSuchColumnException {
        if (this.columnNameMap.get(columnLabel.toLowerCase()) == null) {
            throw new NoSuchColumnException("No such column: " + columnLabel);
        }
        return this.columnNameMap.get(columnLabel.toLowerCase());
    }

    @Override
    public void moveRowPointerTo(int i) {
        this.rowPointer = i;
    }

    @Override
    public int getRowPointer() {
        return this.rowPointer;
    }

    @Override
    public ResultSetType getResultSetType() {
        return ResultSetType.SELECT;
    }
}

