/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.drizzle.packet;

import java.util.ArrayList;
import java.util.List;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.ValueObject;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.LengthEncodedBytes;
import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;
import org.drizzle.jdbc.internal.drizzle.DrizzleType;
import org.drizzle.jdbc.internal.drizzle.DrizzleValueObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowPacket {
    private final List<ValueObject> columns;

    public RowPacket(RawPacket rawPacket, List<ColumnInformation> columnInformation) {
        this.columns = new ArrayList<ValueObject>(columnInformation.size());
        byte[] rawBytes = rawPacket.getRawBytes();
        int readBytes = 0;
        for (ColumnInformation currentColumn : columnInformation) {
            LengthEncodedBytes leb = ReadUtil.getLengthEncodedBytes(rawBytes, readBytes);
            readBytes += leb.getLength();
            DrizzleValueObject dvo = new DrizzleValueObject(leb.getBytes(), (DrizzleType)currentColumn.getType());
            this.columns.add(dvo);
            currentColumn.updateDisplaySize(dvo.getDisplayLength());
        }
    }

    public List<ValueObject> getRow() {
        return this.columns;
    }
}

