/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.drizzle.packet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import org.drizzle.jdbc.internal.common.ServerStatus;
import org.drizzle.jdbc.internal.common.packet.buffer.Reader;
import org.drizzle.jdbc.internal.drizzle.ServerCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreetingReadPacket {
    private final String serverVersion;
    private final byte protocolVersion;
    private final long serverThreadID;
    private final Set<ServerCapabilities> serverCapabilities;
    private final byte serverLanguage;
    private final Set<ServerStatus> serverStatus;
    private final byte[] seed;

    public GreetingReadPacket(InputStream istream) throws IOException {
        Reader reader = new Reader(istream);
        this.protocolVersion = reader.readByte();
        this.serverVersion = reader.readString("ASCII");
        this.serverThreadID = reader.readInt();
        byte[] seed1 = reader.readRawBytes(8);
        reader.skipByte();
        this.serverCapabilities = ServerCapabilities.getServerCapabilitiesSet(reader.readShort());
        this.serverLanguage = reader.readByte();
        this.serverStatus = ServerStatus.getServerStatusSet(reader.readShort());
        reader.skipBytes(13);
        byte[] seed2 = reader.readRawBytes(12);
        this.seed = Arrays.copyOf(seed1, seed1.length + seed2.length);
        System.arraycopy(seed2, 0, this.seed, seed1.length, seed2.length);
        reader.readByte();
    }

    public String toString() {
        return this.protocolVersion + ":" + this.serverVersion + ":" + this.serverThreadID + ":" + new String(this.seed) + ":" + this.serverCapabilities + ":" + this.serverLanguage + ":" + this.serverStatus;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public byte getProtocolVersion() {
        return this.protocolVersion;
    }

    public long getServerThreadID() {
        return this.serverThreadID;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public Set<ServerCapabilities> getServerCapabilities() {
        return this.serverCapabilities;
    }

    public byte getServerLanguage() {
        return this.serverLanguage;
    }

    public Set<ServerStatus> getServerStatus() {
        return this.serverStatus;
    }
}

