/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.drizzle;

import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ServerCapabilities {
    LONG_PASSWORD(1),
    FOUND_ROWS(2),
    LONG_FLAG(4),
    CONNECT_WITH_DB(8),
    NO_SCHEMA(16),
    COMPRESS(32),
    ODBC(64),
    LOCAL_FILES(128),
    IGNORE_SPACE(256),
    CLIENT_PROTOCOL_41(512),
    SSL(2048),
    IGNORE_SIGPIPE(4096),
    RESERVED(16384),
    SECURE_CONNECTION(Short.MIN_VALUE),
    MULTI_STATEMENTS(0),
    MULTI_RESULTS(0);

    private short bitmapFlag;

    private ServerCapabilities(short i) {
        this.bitmapFlag = i;
    }

    public static Set<ServerCapabilities> getServerCapabilitiesSet(short i) {
        EnumSet<ServerCapabilities> statusSet = EnumSet.noneOf(ServerCapabilities.class);
        for (ServerCapabilities value : ServerCapabilities.values()) {
            if ((i & value.getBitmapFlag()) != value.getBitmapFlag()) continue;
            statusSet.add(value);
        }
        return statusSet;
    }

    public short getBitmapFlag() {
        return this.bitmapFlag;
    }

    public static short fromSet(Set<ServerCapabilities> capabilities) {
        short retVal = 0;
        for (ServerCapabilities cap : capabilities) {
            retVal = (short)(retVal | cap.getBitmapFlag());
        }
        return retVal;
    }
}

