/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.drizzle;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import org.drizzle.jdbc.internal.common.DataType;

public class DrizzleType
implements DataType {
    private final Type type;

    public DrizzleType(Type type) {
        this.type = type;
    }

    public Class getJavaType() {
        return this.type.getDataType();
    }

    public int getSqlType() {
        return this.type.getSqlType();
    }

    public Type getType() {
        return this.type;
    }

    public static DrizzleType fromServer(byte typeValue) {
        switch (typeValue) {
            case 0: {
                return new DrizzleType(Type.TINY);
            }
            case 1: {
                return new DrizzleType(Type.LONG);
            }
            case 2: {
                return new DrizzleType(Type.DOUBLE);
            }
            case 3: {
                return new DrizzleType(Type.NULL);
            }
            case 4: {
                return new DrizzleType(Type.TIMESTAMP);
            }
            case 5: {
                return new DrizzleType(Type.LONGLONG);
            }
            case 6: {
                return new DrizzleType(Type.DATETIME);
            }
            case 7: {
                return new DrizzleType(Type.DATE);
            }
            case 8: {
                return new DrizzleType(Type.VARCHAR);
            }
            case 9: {
                return new DrizzleType(Type.NEWDECIMAL);
            }
            case 10: {
                return new DrizzleType(Type.ENUM);
            }
            case 11: {
                return new DrizzleType(Type.BLOB);
            }
            case 12: {
                return new DrizzleType(Type.BLOB);
            }
        }
        return new DrizzleType(Type.VARCHAR);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TINY(5, Short.class),
        LONG(-5, Long.class),
        DOUBLE(8, Double.class),
        NULL(0, null),
        TIMESTAMP(93, Long.class),
        LONGLONG(-5, Long.class),
        DATETIME(91, Date.class),
        DATE(91, Date.class),
        VARCHAR(12, String.class),
        NEWDECIMAL(3, BigDecimal.class),
        ENUM(12, String.class),
        BLOB(2004, Blob.class),
        MAX(2004, Blob.class);

        private int sqlType;
        private Class<?> javaClass;

        private Type(int sqlType, Class<?> javaClass) {
            this.sqlType = sqlType;
            this.javaClass = javaClass;
        }

        public Class getDataType() {
            return this.javaClass;
        }

        public int getSqlType() {
            return this.sqlType;
        }
    }
}

