/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.drizzle;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import org.drizzle.jdbc.internal.SQLExceptionMapper;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.PacketFetcher;
import org.drizzle.jdbc.internal.common.Protocol;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.ServerStatus;
import org.drizzle.jdbc.internal.common.SupportedDatabases;
import org.drizzle.jdbc.internal.common.ValueObject;
import org.drizzle.jdbc.internal.common.packet.AsyncPacketFetcher;
import org.drizzle.jdbc.internal.common.packet.EOFPacket;
import org.drizzle.jdbc.internal.common.packet.ErrorPacket;
import org.drizzle.jdbc.internal.common.packet.OKPacket;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.ResultPacket;
import org.drizzle.jdbc.internal.common.packet.ResultPacketFactory;
import org.drizzle.jdbc.internal.common.packet.ResultSetPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;
import org.drizzle.jdbc.internal.common.packet.commands.ClosePacket;
import org.drizzle.jdbc.internal.common.packet.commands.SelectDBPacket;
import org.drizzle.jdbc.internal.common.packet.commands.StreamedQueryPacket;
import org.drizzle.jdbc.internal.common.query.DrizzleQuery;
import org.drizzle.jdbc.internal.common.query.Query;
import org.drizzle.jdbc.internal.common.queryresults.DrizzleQueryResult;
import org.drizzle.jdbc.internal.common.queryresults.DrizzleUpdateResult;
import org.drizzle.jdbc.internal.common.queryresults.QueryResult;
import org.drizzle.jdbc.internal.drizzle.ServerCapabilities;
import org.drizzle.jdbc.internal.drizzle.packet.FieldPacket;
import org.drizzle.jdbc.internal.drizzle.packet.GreetingReadPacket;
import org.drizzle.jdbc.internal.drizzle.packet.RowPacket;
import org.drizzle.jdbc.internal.drizzle.packet.commands.ClientAuthPacket;
import org.drizzle.jdbc.internal.drizzle.packet.commands.PingPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DrizzleProtocol
implements Protocol {
    private static final Logger log = Logger.getLogger(DrizzleProtocol.class.getName());
    private boolean connected = false;
    private final Socket socket;
    private final BufferedOutputStream writer;
    private final String serverVersion;
    private boolean readOnly = false;
    private boolean autoCommit;
    private final String host;
    private final int port;
    private String database;
    private final String username;
    private final String password;
    private final List<Query> batchList;
    private final PacketFetcher packetFetcher;

    public DrizzleProtocol(String host, int port, String database, String username, String password) throws QueryException {
        this.host = host;
        this.port = port;
        this.database = database == null ? "" : database;
        this.username = username == null ? "" : username;
        this.password = password == null ? "" : password;
        SocketFactory socketFactory = SocketFactory.getDefault();
        try {
            this.socket = socketFactory.createSocket(host, port);
        }
        catch (IOException e) {
            throw new QueryException("Could not connect: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        log.info("Connected to: " + host + ":" + port);
        this.batchList = new ArrayList<Query>();
        try {
            BufferedInputStream reader = new BufferedInputStream(this.socket.getInputStream(), 65536);
            this.writer = new BufferedOutputStream(this.socket.getOutputStream(), 65536);
            GreetingReadPacket greetingPacket = new GreetingReadPacket(reader);
            log.finest("Got greeting packet: " + greetingPacket);
            this.serverVersion = greetingPacket.getServerVersion();
            EnumSet<ServerCapabilities> serverCapabilities = EnumSet.of(ServerCapabilities.LONG_PASSWORD, ServerCapabilities.CONNECT_WITH_DB, ServerCapabilities.IGNORE_SPACE, ServerCapabilities.CLIENT_PROTOCOL_41, ServerCapabilities.SECURE_CONNECTION);
            ClientAuthPacket cap = new ClientAuthPacket(this.username, this.password, this.database, serverCapabilities);
            cap.send(this.writer);
            log.finest("Sending auth packet");
            this.packetFetcher = new AsyncPacketFetcher(reader);
            this.packetFetcher.start();
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            ResultPacket rp = ResultPacketFactory.createResultPacket(rawPacket);
            if (rp.getResultType() == ResultPacket.ResultType.ERROR) {
                ErrorPacket ep = (ErrorPacket)rp;
                String message = ep.getMessage();
                throw new QueryException("Could not connect: " + message, ep.getErrorNumber(), ep.getSqlState());
            }
            if (!((OKPacket)rp).getServerStatus().contains((Object)ServerStatus.AUTOCOMMIT)) {
                this.setAutoCommit(true);
            }
        }
        catch (IOException e) {
            this.close();
            throw new QueryException("Could not connect: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        this.connected = true;
    }

    @Override
    public void close() throws QueryException {
        log.info("Closing connection");
        try {
            this.packetFetcher.close();
            ClosePacket closePacket = new ClosePacket();
            closePacket.send(this.writer);
            this.packetFetcher.awaitTermination();
            this.writer.close();
        }
        catch (IOException e) {
            throw new QueryException("Could not close socket: " + e.getMessage(), -1, "08000", e);
        }
        finally {
            try {
                this.connected = false;
                this.socket.close();
            }
            catch (IOException e) {
                log.warning("Could not close socket");
            }
        }
    }

    @Override
    public boolean isClosed() {
        return !this.connected;
    }

    @Override
    public void selectDB(String database) throws QueryException {
        log.finest("Selecting db " + database);
        SelectDBPacket packet = new SelectDBPacket(database);
        try {
            packet.send(this.writer);
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            ResultPacketFactory.createResultPacket(rawPacket);
        }
        catch (IOException e) {
            throw new QueryException("Could not connect: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        this.database = database;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public void setReadonly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean getReadonly() {
        return this.readOnly;
    }

    @Override
    public void commit() throws QueryException {
        log.finest("commiting transaction");
        this.executeQuery(new DrizzleQuery("COMMIT"));
    }

    @Override
    public void rollback() throws QueryException {
        log.finest("rolling transaction back");
        this.executeQuery(new DrizzleQuery("ROLLBACK"));
    }

    @Override
    public void rollback(String savepoint) throws QueryException {
        log.finest("rolling back to savepoint: " + savepoint);
        this.executeQuery(new DrizzleQuery("ROLLBACK TO SAVEPOINT " + savepoint));
    }

    @Override
    public void setSavepoint(String savepoint) throws QueryException {
        log.finest("setting a savepoint named " + savepoint);
        this.executeQuery(new DrizzleQuery("SAVEPOINT " + savepoint));
    }

    @Override
    public void releaseSavepoint(String savepoint) throws QueryException {
        log.finest("releasing savepoint named " + savepoint);
        this.executeQuery(new DrizzleQuery("RELEASE SAVEPOINT " + savepoint));
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws QueryException {
        this.autoCommit = autoCommit;
        String boolStr = "0";
        if (autoCommit) {
            boolStr = "1";
        }
        this.executeQuery(new DrizzleQuery("SET autocommit=" + boolStr));
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean ping() throws QueryException {
        PingPacket pingPacket = new PingPacket();
        try {
            pingPacket.send(this.writer);
            log.finest("Sent ping packet");
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            return ResultPacketFactory.createResultPacket(rawPacket).getResultType() == ResultPacket.ResultType.OK;
        }
        catch (IOException e) {
            throw new QueryException("Could not ping: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public QueryResult executeQuery(Query dQuery) throws QueryException {
        log.finest("Executing streamed query: " + dQuery);
        StreamedQueryPacket packet = new StreamedQueryPacket(dQuery);
        boolean i = false;
        try {
            packet.send(this.writer);
        }
        catch (IOException e) {
            throw new QueryException("Could not connect: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        RawPacket rawPacket = null;
        try {
            rawPacket = this.packetFetcher.getRawPacket();
        }
        catch (IOException e) {
            throw new QueryException("Could not connect: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        ResultPacket resultPacket = ResultPacketFactory.createResultPacket(rawPacket);
        switch (resultPacket.getResultType()) {
            case ERROR: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ErrorPacket ep = (ErrorPacket)resultPacket;
                try {
                    dQuery.writeTo(baos);
                    log.warning("Could not execute query " + baos.toString() + ": " + ep.getMessage());
                    throw new QueryException("Could not execute query: " + ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
                }
                catch (IOException e) {
                    throw new QueryException("Could not execute query: " + ((ErrorPacket)resultPacket).getMessage());
                }
            }
            case OK: {
                OKPacket okpacket = (OKPacket)resultPacket;
                DrizzleUpdateResult updateResult = new DrizzleUpdateResult(okpacket.getAffectedRows(), okpacket.getWarnings(), okpacket.getMessage(), okpacket.getInsertId());
                log.finest("OK, " + okpacket.getAffectedRows());
                return updateResult;
            }
            case RESULTSET: {
                log.finest("SELECT executed, fetching result set");
                try {
                    return this.createDrizzleQueryResult((ResultSetPacket)resultPacket);
                }
                catch (IOException e) {
                    throw new QueryException("Could not connect: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
        }
        log.severe("Could not parse result...");
        throw new QueryException("Could not parse result");
    }

    private QueryResult createDrizzleQueryResult(ResultSetPacket packet) throws IOException {
        RawPacket rawPacket;
        ArrayList<ColumnInformation> columnInformation = new ArrayList<ColumnInformation>();
        int i = 0;
        while ((long)i < packet.getFieldCount()) {
            rawPacket = this.packetFetcher.getRawPacket();
            ColumnInformation columnInfo = FieldPacket.columnInformationFactory(rawPacket);
            columnInformation.add(columnInfo);
            ++i;
        }
        this.packetFetcher.getRawPacket();
        ArrayList<List<ValueObject>> valueObjects = new ArrayList<List<ValueObject>>();
        while (true) {
            if (ReadUtil.eofIsNext(rawPacket = this.packetFetcher.getRawPacket())) {
                EOFPacket eofPacket = (EOFPacket)ResultPacketFactory.createResultPacket(rawPacket);
                return new DrizzleQueryResult(columnInformation, valueObjects, eofPacket.getWarningCount());
            }
            RowPacket rowPacket = new RowPacket(rawPacket, columnInformation);
            valueObjects.add(rowPacket.getRow());
        }
    }

    @Override
    public void addToBatch(Query dQuery) {
        log.fine("Adding query to batch");
        this.batchList.add(dQuery);
    }

    @Override
    public List<QueryResult> executeBatch() throws QueryException {
        log.fine("executing batch");
        ArrayList<QueryResult> retList = new ArrayList<QueryResult>(this.batchList.size());
        boolean i = false;
        for (Query query : this.batchList) {
            log.finest("executing batch query");
            retList.add(this.executeQuery(query));
        }
        this.clearBatch();
        return retList;
    }

    @Override
    public void clearBatch() {
        this.batchList.clear();
    }

    @Override
    public List<RawPacket> startBinlogDump(int startPos, String filename) {
        return null;
    }

    @Override
    public SupportedDatabases getDatabaseType() {
        return SupportedDatabases.DRIZZLE;
    }
}

