/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class StringParameter
implements ParameterHolder {
    private final byte[] byteRepresentation;

    public StringParameter(String parameter) {
        String tempParam = "\"" + Utils.sqlEscapeString(parameter) + "\"";
        try {
            this.byteRepresentation = tempParam.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("unsupp encoding: " + e.getMessage(), e);
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        for (byte b : this.byteRepresentation) {
            os.write(b);
        }
    }

    public long length() {
        return this.byteRepresentation.length;
    }
}

