/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.query.IllegalParameterException;
import org.drizzle.jdbc.internal.common.query.ParameterizedQuery;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrizzleParameterizedQuery
implements ParameterizedQuery {
    private static final Logger log = Logger.getLogger(DrizzleParameterizedQuery.class.getName());
    private Map<Integer, ParameterHolder> parameters;
    private final int paramCount;
    private final String query;

    public DrizzleParameterizedQuery(String query) {
        this.query = query;
        this.paramCount = Utils.countChars(query, '?');
        log.finest("Found " + this.paramCount + " questionmarks");
        this.parameters = new HashMap<Integer, ParameterHolder>();
    }

    public DrizzleParameterizedQuery(ParameterizedQuery query) {
        this.query = query.getQuery();
        this.paramCount = query.getParamCount();
        this.parameters = new HashMap<Integer, ParameterHolder>();
        log.finest("Copying an existing parameterized query");
    }

    @Override
    public void setParameter(int position, ParameterHolder parameter) throws IllegalParameterException {
        log.finest("Setting parameter " + parameter.toString() + " at position " + position);
        if (position < 0 || position >= this.paramCount) {
            throw new IllegalParameterException("No '?' on that position");
        }
        this.parameters.put(position, parameter);
    }

    @Override
    public Map<Integer, ParameterHolder> getParameters() {
        return this.parameters;
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
    }

    @Override
    public int length() {
        int length = this.query.length() - this.paramCount;
        for (Map.Entry<Integer, ParameterHolder> param : this.parameters.entrySet()) {
            length = (int)((long)length + param.getValue().length());
        }
        return length;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException, QueryException {
        int ch;
        if (this.paramCount != this.parameters.size()) {
            throw new QueryException("You need to set exactly " + this.paramCount + " parameters on the prepared statement");
        }
        StringReader strReader = new StringReader(this.query);
        int paramCounter = 0;
        while ((ch = strReader.read()) != -1) {
            if (ch == 63) {
                this.parameters.get(paramCounter++).writeTo(os);
                continue;
            }
            os.write(ch);
        }
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }
}

