/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet.buffer;

import java.util.ArrayList;
import java.util.List;

public class WriteBuffer {
    private List<Byte> buffer = new ArrayList<Byte>();

    public WriteBuffer writeByte(byte theByte) {
        this.buffer.add(theByte);
        return this;
    }

    public WriteBuffer writeByteArray(byte[] bytes) {
        for (byte b : bytes) {
            this.writeByte(b);
        }
        return this;
    }

    public WriteBuffer writeBytes(byte theByte, int count) {
        for (int i = 0; i < count; ++i) {
            this.writeByte(theByte);
        }
        return this;
    }

    public WriteBuffer writeShort(short theInt) {
        byte[] b = WriteBuffer.shortToByteArray(theInt);
        this.buffer.add(b[0]);
        this.buffer.add(b[1]);
        return this;
    }

    public WriteBuffer writeInt(int theLong) {
        byte[] b;
        for (byte aB : b = WriteBuffer.intToByteArray(theLong)) {
            this.buffer.add(aB);
        }
        return this;
    }

    public WriteBuffer writeString(String str) {
        byte[] strBytes;
        for (byte aByte : strBytes = str.getBytes()) {
            this.buffer.add(aByte);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] returnArray = new byte[this.buffer.size()];
        int i = 0;
        for (Byte b : this.buffer) {
            returnArray[i++] = b;
        }
        return returnArray;
    }

    public byte[] toByteArrayWithLength(byte packetNumber) {
        int length = this.buffer.size();
        byte[] bufferBytes = new byte[this.buffer.size() + 4];
        byte[] lengthBytes = WriteBuffer.intToByteArray(length);
        lengthBytes[3] = packetNumber;
        int i = 0;
        for (byte aB : lengthBytes) {
            bufferBytes[i++] = aB;
        }
        for (Byte aB : this.buffer) {
            bufferBytes[i++] = aB;
        }
        return bufferBytes;
    }

    public static byte[] shortToByteArray(short i) {
        byte[] returnArray = new byte[]{(byte)(i & 0xFF), (byte)(i >>> 8)};
        return returnArray;
    }

    public static byte[] intToByteArray(int l) {
        byte[] returnArray = new byte[]{(byte)(l & 0xFF), (byte)(l >>> 8), (byte)(l >>> 16), (byte)(l >>> 24)};
        return returnArray;
    }

    public static byte[] longToByteArray(long l) {
        byte[] returnArray = new byte[8];
        returnArray[0] = (byte)(l & 0xFFL);
        returnArray[1] = (byte)(l >>> 8);
        returnArray[2] = (byte)(l >>> 16);
        returnArray[3] = (byte)(l >>> 24);
        returnArray[0] = (byte)(l >>> 32);
        returnArray[1] = (byte)(l >>> 40);
        returnArray[2] = (byte)(l >>> 48);
        returnArray[3] = (byte)(l >>> 56);
        return returnArray;
    }
}

