/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet.buffer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.drizzle.jdbc.internal.common.packet.RawPacket;

public class Reader {
    private final InputStream reader;
    private final int length;
    private int readBytes = 0;
    private final byte packetSeq;

    public Reader(InputStream reader) throws IOException {
        this.reader = reader;
        this.length = this.readLength();
        this.packetSeq = this.readPacketSeq();
    }

    public Reader(RawPacket rawPacket) {
        this.reader = new ByteArrayInputStream(rawPacket.getRawBytes());
        this.length = rawPacket.getRawBytes().length;
        this.packetSeq = 0;
    }

    private int readLength() throws IOException {
        byte[] lengthBuffer = new byte[3];
        for (int i = 0; i < 3; ++i) {
            lengthBuffer[i] = (byte)this.reader.read();
        }
        return (lengthBuffer[0] & 0xFF) + (lengthBuffer[1] << 8) + (lengthBuffer[2] << 16);
    }

    private byte readPacketSeq() throws IOException {
        return (byte)this.reader.read();
    }

    public String readString(String charset) throws IOException {
        int ch = 0;
        byte[] tempArr = new byte[this.length - this.readBytes];
        int i = 0;
        while (this.readBytes < this.length && (ch = this.reader.read()) != 0) {
            ++this.readBytes;
            tempArr[i++] = (byte)ch;
        }
        return new String(tempArr, charset);
    }

    public short readShort() throws IOException {
        if (this.readBytes + 2 > this.length) {
            throw new IOException("Could not read short");
        }
        byte[] tempBuf = new byte[]{(byte)this.reader.read(), (byte)this.reader.read()};
        this.readBytes += 2;
        return (short)((tempBuf[0] & 0xFF) + ((tempBuf[1] & 0xFF) << 8));
    }

    public int readInt() throws IOException {
        if (this.readBytes + 4 > this.length) {
            throw new IOException("Could not read int");
        }
        byte[] tempBuf = new byte[4];
        for (int i = 0; i < 4; ++i) {
            tempBuf[i] = (byte)this.reader.read();
        }
        this.readBytes += 4;
        return (tempBuf[0] & 0xFF) + ((tempBuf[1] & 0xFF) << 8) + ((tempBuf[2] & 0xFF) << 16) + ((tempBuf[3] & 0xFF) << 24);
    }

    public long readLong() throws IOException {
        if (this.readBytes + 8 > this.length) {
            throw new IOException("Could not read short");
        }
        byte[] tempBuf = new byte[8];
        for (int i = 0; i < 8; ++i) {
            tempBuf[i] = (byte)this.reader.read();
        }
        this.readBytes += 8;
        return (long)(tempBuf[0] & 0xFF) + ((long)(tempBuf[1] & 0xFF) << 8) + ((long)(tempBuf[2] & 0xFF) << 16) + ((long)(tempBuf[3] & 0xFF) << 24) + ((long)(tempBuf[4] & 0xFF) << 32) + ((long)(tempBuf[5] & 0xFF) << 40) + ((long)(tempBuf[6] & 0xFF) << 48) + ((long)(tempBuf[7] & 0xFF) << 56);
    }

    public byte readByte() throws IOException {
        if (this.readBytes >= this.length) {
            throw new IOException("Could not read byte");
        }
        ++this.readBytes;
        return (byte)this.reader.read();
    }

    public byte[] readRawBytes(int numberOfBytes) throws IOException {
        if (this.readBytes + numberOfBytes >= this.length) {
            throw new IOException("Could not read bytes");
        }
        byte[] tmpArr = new byte[numberOfBytes];
        for (int i = 0; i < numberOfBytes; ++i) {
            tmpArr[i] = (byte)this.reader.read();
        }
        this.readBytes += numberOfBytes;
        return tmpArr;
    }

    public void skipByte() throws IOException {
        this.skipBytes(1);
    }

    public long skipBytes(int bytesToSkip) throws IOException {
        if (this.readBytes + bytesToSkip > this.length) {
            throw new IOException("Could not skip bytes");
        }
        this.readBytes += bytesToSkip;
        return this.reader.skip(bytesToSkip);
    }

    public int read24bitword() throws IOException {
        if (this.readBytes + 3 >= this.length) {
            throw new IOException("Could not read 3 bytes");
        }
        byte[] tmpArr = new byte[3];
        for (int i = 0; i < 3; ++i) {
            tmpArr[i] = (byte)this.reader.read();
        }
        this.readBytes += 3;
        return (tmpArr[0] & 0xFF) + ((tmpArr[1] & 0xFF) << 8) + ((tmpArr[2] & 0xFF) << 16);
    }

    public long getLengthEncodedBinary() throws IOException {
        if (this.readBytes >= this.length) {
            throw new IOException("Could not read length encoded binary (" + this.readBytes + ")(" + this.length + ")");
        }
        byte type = (byte)this.reader.read();
        ++this.readBytes;
        if ((type & 0xFF) == 251) {
            return -1L;
        }
        if ((type & 0xFF) == 252) {
            return this.readShort();
        }
        if ((type & 0xFF) == 253) {
            return this.read24bitword();
        }
        if ((type & 0xFF) == 254) {
            return this.readLong();
        }
        if ((type & 0xFF) <= 250) {
            return type;
        }
        return 0L;
    }

    public byte peek() throws IOException {
        this.reader.mark(2);
        byte b = (byte)this.reader.read();
        this.reader.reset();
        return b;
    }

    public String getLengthEncodedString() throws IOException {
        long encLength = this.getLengthEncodedBinary();
        if (encLength == -1L) {
            return null;
        }
        if ((long)this.readBytes + encLength > (long)this.length) {
            throw new IOException("Could not read length encoded binary (" + this.readBytes + ")(" + encLength + ")(" + this.length + ")");
        }
        byte[] tmpBuf = new byte[(int)encLength];
        int i = 0;
        while ((long)i < encLength) {
            tmpBuf[i] = (byte)this.reader.read();
            ++i;
        }
        this.readBytes = (int)((long)this.readBytes + encLength);
        return new String(tmpBuf, "ASCII");
    }

    public byte[] getLengthEncodedBytes() throws IOException {
        long encLength = this.getLengthEncodedBinary();
        if (encLength == -1L) {
            return null;
        }
        if ((long)this.readBytes + encLength > (long)this.length) {
            throw new IOException("Could not read length encoded binary (" + this.readBytes + ")(" + encLength + ")(" + this.length + ")");
        }
        byte[] tmpBuf = new byte[(int)encLength];
        int i = 0;
        while ((long)i < encLength) {
            tmpBuf[i] = (byte)this.reader.read();
            ++i;
        }
        this.readBytes = (int)((long)this.readBytes + encLength);
        return tmpBuf;
    }

    public byte getByteAt(int i) throws IOException {
        this.reader.mark(i + 1);
        long skipped = this.reader.skip(i - 1);
        if (skipped != (long)(i - 1)) {
            throw new IOException("Could not skip the requested amount of bytes");
        }
        byte b = (byte)this.reader.read();
        this.reader.reset();
        return b;
    }

    public byte getPacketSeq() {
        return this.packetSeq;
    }
}

