/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.LengthEncodedBinary;
import org.drizzle.jdbc.internal.common.packet.buffer.LengthEncodedBytes;

public class ReadUtil {
    private static int readLength(InputStream reader) throws IOException {
        byte[] lengthBuffer = new byte[3];
        if (ReadUtil.safeRead(reader, lengthBuffer) != 3) {
            throw new IOException("Incomplete read!");
        }
        return (lengthBuffer[0] & 0xFF) + ((lengthBuffer[1] & 0xFF) << 8) + ((lengthBuffer[2] & 0xFF) << 16);
    }

    public static int safeRead(InputStream is, byte[] buffer) throws IOException {
        int offset = 0;
        int left = buffer.length;
        do {
            try {
                int nr = is.read(buffer, offset, left);
                if (nr == -1) {
                    return nr;
                }
                offset += nr;
                left -= nr;
            }
            catch (InterruptedIOException exp) {
                // empty catch block
            }
        } while (left > 0);
        return buffer.length;
    }

    private static byte readPacketSeq(InputStream reader) throws IOException {
        return (byte)reader.read();
    }

    public static byte getByteAt(InputStream reader, int i) throws IOException {
        reader.mark(i + 1);
        long skipped = reader.skip(i - 1);
        if (skipped != (long)(i - 1)) {
            throw new IOException("Could not skip the requested number of bytes.");
        }
        byte b = (byte)reader.read();
        reader.reset();
        return b;
    }

    public static boolean eofIsNext(InputStream reader) throws IOException {
        reader.mark(10);
        int length = ReadUtil.readLength(reader);
        byte packetType = (byte)reader.read();
        reader.reset();
        return packetType == -2 && length < 9;
    }

    public static boolean eofIsNext(RawPacket rawPacket) {
        byte[] rawBytes = rawPacket.getRawBytes();
        return rawBytes[0] == -2 && rawBytes.length < 9;
    }

    public static short readShort(byte[] bytes, int start) {
        short length = 0;
        if (bytes.length - start >= 2) {
            length = (short)((bytes[start] & 0xFF) + (short)((bytes[start + 1] & 0xFF) << 8));
        }
        return length;
    }

    public static int read16bitword(byte[] bytes, int start) {
        int length = 0;
        if (bytes.length - start >= 2) {
            length = (bytes[start] & 0xFF) + ((bytes[start + 1] & 0xFF) << 8);
        }
        return length;
    }

    public static int read24bitword(byte[] bytes, int start) {
        return (bytes[start] & 0xFF) + ((bytes[start + 1] & 0xFF) << 8) + ((bytes[start + 2] & 0xFF) << 16);
    }

    public static long readLong(byte[] bytes, int start) {
        long length = ((long)bytes[start] & 0xFFL) + (((long)bytes[start + 1] & 0xFFL) << 8) + (((long)bytes[start + 2] & 0xFFL) << 16) + (((long)bytes[start + 3] & 0xFFL) << 24) + (((long)bytes[start + 4] & 0xFFL) << 32) + (((long)bytes[start + 5] & 0xFFL) << 40) + (((long)bytes[start + 6] & 0xFFL) << 48) + (((long)bytes[start + 7] & 0xFFL) << 56);
        return length;
    }

    public static LengthEncodedBytes getLengthEncodedBytes(byte[] rawBytes, int start) {
        return new LengthEncodedBytes(rawBytes, start);
    }

    public static LengthEncodedBinary getLengthEncodedBinary(byte[] rawBytes, int start) {
        return new LengthEncodedBinary(rawBytes, start);
    }
}

