/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet.buffer;

import java.util.Arrays;
import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;

public class LengthEncodedBytes {
    private final byte[] theBytes;
    private final int length;

    public LengthEncodedBytes(byte[] rawBytes, int start) {
        if (start < rawBytes.length) {
            switch (rawBytes[start] & 0xFF) {
                case 251: {
                    this.theBytes = null;
                    this.length = 1;
                    break;
                }
                case 252: {
                    int tempLength = ReadUtil.readShort(rawBytes, start + 1) & 0xFFFF;
                    this.theBytes = Arrays.copyOfRange(rawBytes, start + 3, tempLength + start + 3);
                    this.length = tempLength + 3;
                    break;
                }
                case 253: {
                    int tempLength = ReadUtil.read24bitword(rawBytes, start + 1);
                    this.theBytes = Arrays.copyOfRange(rawBytes, start + 4, tempLength + start + 4);
                    this.length = tempLength + 4;
                    break;
                }
                case 254: {
                    int tempLength = (int)ReadUtil.readLong(rawBytes, start + 1);
                    this.theBytes = Arrays.copyOfRange(rawBytes, start + 9, tempLength + start + 9);
                    this.length = tempLength + 9;
                    break;
                }
                default: {
                    this.theBytes = Arrays.copyOfRange(rawBytes, start + 1, start + 1 + (rawBytes[start] & 0xFF));
                    this.length = this.theBytes.length + 1;
                    break;
                }
            }
        } else {
            this.theBytes = null;
            this.length = 0;
        }
    }

    public byte[] getBytes() {
        return this.theBytes;
    }

    public int getLength() {
        return this.length;
    }
}

