/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet.buffer;

import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;

public class LengthEncodedBinary {
    private final int length;
    private final long value;

    public LengthEncodedBinary(byte[] rawBytes, int start) {
        if (start < rawBytes.length) {
            switch (rawBytes[start] & 0xFF) {
                case 251: {
                    this.length = 1;
                    this.value = -1L;
                    break;
                }
                case 252: {
                    this.value = ReadUtil.readShort(rawBytes, start + 1) & 0xFFFF;
                    this.length = 3;
                    break;
                }
                case 253: {
                    this.value = ReadUtil.read24bitword(rawBytes, start + 1);
                    this.length = 4;
                    break;
                }
                case 254: {
                    this.value = ReadUtil.readLong(rawBytes, start + 1);
                    this.length = 9;
                    break;
                }
                default: {
                    this.value = rawBytes[start] & 0xFF;
                    this.length = 1;
                    break;
                }
            }
        } else {
            this.length = 0;
            this.value = 0L;
        }
    }

    public int getLength() {
        return this.length;
    }

    public long getValue() {
        return this.value;
    }
}

