/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet;

import java.io.IOException;
import java.io.InputStream;
import org.drizzle.jdbc.internal.common.packet.ResultPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.LengthEncodedBinary;
import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;
import org.drizzle.jdbc.internal.common.packet.buffer.Reader;

public class ResultSetPacket
extends ResultPacket {
    private final long fieldCount;

    public ResultSetPacket(InputStream istream) throws IOException {
        Reader reader = new Reader(istream);
        this.fieldCount = reader.getLengthEncodedBinary();
    }

    public ResultSetPacket(byte[] rawBytes) {
        LengthEncodedBinary leb = ReadUtil.getLengthEncodedBinary(rawBytes, 0);
        this.fieldCount = leb.getValue();
    }

    public ResultPacket.ResultType getResultType() {
        return ResultPacket.ResultType.RESULTSET;
    }

    public byte getPacketSeq() {
        return 0;
    }

    public long getFieldCount() {
        return this.fieldCount;
    }
}

