/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet;

import java.io.IOException;
import java.io.InputStream;
import org.drizzle.jdbc.internal.common.packet.EOFPacket;
import org.drizzle.jdbc.internal.common.packet.ErrorPacket;
import org.drizzle.jdbc.internal.common.packet.OKPacket;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.ResultPacket;
import org.drizzle.jdbc.internal.common.packet.ResultSetPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;

public class ResultPacketFactory {
    private static final byte ERROR = -1;
    private static final byte OK = 0;
    private static final byte EOF = -2;

    public static ResultPacket createResultPacket(InputStream reader) throws IOException {
        switch (ReadUtil.getByteAt(reader, 5)) {
            case -1: {
                return new ErrorPacket(reader);
            }
            case 0: {
                return new OKPacket(reader);
            }
            case -2: {
                return new EOFPacket(reader);
            }
        }
        return new ResultSetPacket(reader);
    }

    public static ResultPacket createResultPacket(RawPacket rawPacket) {
        byte[] rawBytes = rawPacket.getRawBytes();
        switch (rawBytes[0]) {
            case -1: {
                return new ErrorPacket(rawBytes);
            }
            case 0: {
                return new OKPacket(rawBytes);
            }
            case -2: {
                return new EOFPacket(rawBytes);
            }
        }
        return new ResultSetPacket(rawBytes);
    }
}

