/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet;

import java.io.IOException;
import java.io.InputStream;
import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;

public final class RawPacket {
    static final RawPacket IOEXCEPTION_PILL = new RawPacket(null, -1);
    private final byte[] rawBytes;
    private final int packetSeq;

    static RawPacket nextPacket(InputStream is) throws IOException {
        int length = RawPacket.readLength(is);
        if (length == -1) {
            return null;
        }
        if (length < 0) {
            throw new IOException("Got negative packet size: " + length);
        }
        byte packetSeq = RawPacket.readPacketSeq(is);
        byte[] rawBytes = new byte[length];
        int nr = ReadUtil.safeRead(is, rawBytes);
        if (nr != length) {
            throw new IOException("EOF. Expected " + length + ", got " + nr);
        }
        return new RawPacket(rawBytes, packetSeq);
    }

    private RawPacket(byte[] rawBytes, int packetSeq) {
        this.rawBytes = rawBytes;
        this.packetSeq = packetSeq;
    }

    private static byte readPacketSeq(InputStream reader) throws IOException {
        int val = reader.read();
        if (val == -1) {
            throw new IOException("EOF");
        }
        return (byte)val;
    }

    private static int readLength(InputStream reader) throws IOException {
        byte[] lengthBuffer = new byte[3];
        int nr = ReadUtil.safeRead(reader, lengthBuffer);
        if (nr == -1) {
            return -1;
        }
        if (nr != 3) {
            throw new IOException("Incomplete read! Expected 3, got " + nr);
        }
        return (lengthBuffer[0] & 0xFF) + ((lengthBuffer[1] & 0xFF) << 8) + ((lengthBuffer[2] & 0xFF) << 16);
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public int getPacketSeq() {
        return this.packetSeq;
    }
}

