/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.drizzle.jdbc.internal.common.packet.ResultPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;
import org.drizzle.jdbc.internal.common.packet.buffer.Reader;

public class ErrorPacket
extends ResultPacket {
    private final byte fieldCount;
    private final short errorNumber;
    private final byte sqlStateMarker;
    private final byte[] sqlState;
    private final String message;

    public ErrorPacket(InputStream istream) throws IOException {
        Reader reader = new Reader(istream);
        this.fieldCount = reader.readByte();
        this.errorNumber = reader.readShort();
        this.sqlStateMarker = reader.readByte();
        this.sqlState = reader.readRawBytes(5);
        this.message = reader.readString("ASCII");
    }

    public ErrorPacket(byte[] rawBytes) {
        this.fieldCount = rawBytes[0];
        this.errorNumber = ReadUtil.readShort(rawBytes, 1);
        this.sqlStateMarker = rawBytes[3];
        this.sqlState = Arrays.copyOfRange(rawBytes, 4, 9);
        this.message = new String(rawBytes, 9, rawBytes.length - 9);
    }

    public String getMessage() {
        return this.message;
    }

    public ResultPacket.ResultType getResultType() {
        return ResultPacket.ResultType.ERROR;
    }

    public byte getPacketSeq() {
        return 0;
    }

    public short getErrorNumber() {
        return this.errorNumber;
    }

    public String getSqlState() {
        return new String(this.sqlState);
    }
}

