/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet;

import java.io.IOException;
import java.io.InputStream;
import org.drizzle.jdbc.internal.common.packet.ResultPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;
import org.drizzle.jdbc.internal.common.packet.buffer.Reader;

public class EOFPacket
extends ResultPacket {
    private final byte packetSeq;
    private final short warningCount;
    private short statusFlags;

    public EOFPacket(InputStream istream) throws IOException {
        Reader reader = new Reader(istream);
        this.packetSeq = reader.getPacketSeq();
        byte packetType = reader.readByte();
        if (packetType != -2) {
            throw new IOException("Could not create EOF packet");
        }
        this.warningCount = reader.readShort();
        reader.readShort();
    }

    public EOFPacket(byte[] rawBytes) {
        this.packetSeq = 0;
        this.warningCount = ReadUtil.readShort(rawBytes, 1);
        this.statusFlags = ReadUtil.readShort(rawBytes, 3);
    }

    public ResultPacket.ResultType getResultType() {
        return ResultPacket.ResultType.EOF;
    }

    public byte getPacketSeq() {
        return this.packetSeq;
    }

    public short getWarningCount() {
        return this.warningCount;
    }

    public short getStatusFlags() {
        return this.statusFlags;
    }
}

