/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drizzle.jdbc.internal.common.PacketFetcher;
import org.drizzle.jdbc.internal.common.packet.RawPacket;

public class AsyncPacketFetcher
implements Runnable,
PacketFetcher {
    private final BlockingQueue<RawPacket> packet = new LinkedBlockingQueue<RawPacket>();
    private final InputStream inputStream;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "DrizzlePacketFetcherThread");
        }
    });
    private volatile boolean shutDown = false;

    public AsyncPacketFetcher(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void start() {
        this.executorService.submit(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (!this.shutDown) {
                try {
                    RawPacket rawPacket = RawPacket.nextPacket(this.inputStream);
                    if (rawPacket != null) {
                        this.packet.add(rawPacket);
                        continue;
                    }
                    Logger.getLogger(this.getClass().getName()).info("Connection closed");
                    this.shutDown = true;
                    this.packet.add(RawPacket.IOEXCEPTION_PILL);
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Got exception reading packet", e);
                    this.packet.add(RawPacket.IOEXCEPTION_PILL);
                    this.shutDown = true;
                }
            }
            try {
                this.inputStream.close();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Got exception ", t);
        }
    }

    public RawPacket getRawPacket() throws IOException {
        try {
            RawPacket rawPacket = this.packet.take();
            if (rawPacket == RawPacket.IOEXCEPTION_PILL) {
                throw new IOException();
            }
            return rawPacket;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Got interrupted while waiting for a packet", e);
        }
    }

    public void awaitTermination() {
        try {
            this.executorService.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("executorService shutdown problem", e);
        }
    }

    public void close() {
        this.shutDown = true;
        this.executorService.shutdownNow();
    }
}

