/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Utils {
    private static final int START_BIT_MILLISECONDS = 17;
    private static final int START_BIT_SECONDS = 11;
    private static final int START_BIT_MINUTES = 5;
    private static final int MASK_HOURS = 31;
    private static final int MASK_MINUTES = 2016;
    private static final int MASK_SECONDS = 129024;
    private static final int MASK_MILLISECONDS = -131072;

    public static boolean needsEscaping(byte b) {
        if ((b & 0x80) == 0) {
            switch (b) {
                case 0: 
                case 10: 
                case 13: 
                case 26: 
                case 34: 
                case 39: 
                case 92: {
                    return true;
                }
            }
        }
        return false;
    }

    public static String sqlEscapeString(String str) {
        byte[] strBytes = str.getBytes();
        byte[] outBytes = new byte[strBytes.length * 2];
        int bytePointer = 0;
        for (byte b : strBytes) {
            if (Utils.needsEscaping(b)) {
                outBytes[bytePointer++] = 92;
                outBytes[bytePointer++] = b;
                continue;
            }
            outBytes[bytePointer++] = b;
        }
        return new String(outBytes, 0, bytePointer);
    }

    public static int countChars(String str, char c) {
        int count = 0;
        for (byte b : str.getBytes()) {
            if (c != b) continue;
            ++count;
        }
        return count;
    }

    public static byte[] encryptPassword(String password, byte[] seed) throws NoSuchAlgorithmException {
        if (password == null || password.equals("")) {
            return new byte[0];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] stage1 = messageDigest.digest(password.getBytes());
        messageDigest.reset();
        byte[] stage2 = messageDigest.digest(stage1);
        messageDigest.reset();
        messageDigest.update(seed);
        messageDigest.update(stage2);
        byte[] digest = messageDigest.digest();
        byte[] returnBytes = new byte[digest.length];
        for (int i = 0; i < digest.length; ++i) {
            returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
        }
        return returnBytes;
    }

    public static int packTime(long milliseconds) {
        int millis = (int)(milliseconds % 1000L);
        int seconds = (int)(milliseconds / 1000L % 60L);
        int minutes = (int)(milliseconds / 60000L % 60L);
        int hours = (int)(milliseconds / 3600000L % 24L);
        return millis * 131072 + seconds * 2048 + minutes * 32 + hours;
    }

    public static long unpackTime(int packedTime) {
        int hours = packedTime & 0x1F;
        int minutes = (packedTime & 0x7E0) >> 5;
        int seconds = (packedTime & 0x1F800) >> 11;
        int millis = (packedTime & 0xFFFE0000) >> 17;
        long returnValue = (long)hours * 60L * 60L * 1000L;
        returnValue += (long)minutes * 60L * 1000L;
        returnValue += (long)seconds * 1000L;
        return returnValue += (long)millis;
    }
}

