/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCUrl {
    private final DBType dbType;
    private final String username;
    private final String password;
    private final String hostname;
    private final int port;
    private final String database;

    public JDBCUrl(String url) throws SQLException {
        Pattern p = Pattern.compile("^jdbc:(drizzle|mysql:thin)://((\\w+)(:(\\w+))?@)?([^/:]+)(:(\\d+))?(/(\\w+))?");
        Matcher m = p.matcher(url);
        if (!m.find()) {
            throw new SQLException("Could not parse connection string...");
        }
        this.dbType = m.group(1).equals("mysql:thin") ? DBType.MYSQL : DBType.DRIZZLE;
        this.username = m.group(3) == null ? "" : m.group(3);
        this.password = m.group(5) == null ? "" : m.group(5);
        String string = this.hostname = m.group(6) == null ? "" : m.group(6);
        this.port = m.group(8) != null ? Integer.parseInt(m.group(8)) : (this.dbType == DBType.DRIZZLE ? 4427 : 3306);
        this.database = m.group(10);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBType {
        DRIZZLE,
        MYSQL;

    }
}

