/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Logger;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.queryresults.ColumnFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrizzleResultSetMetaData
implements ResultSetMetaData {
    private static final Logger log = Logger.getLogger(DrizzleResultSetMetaData.class.getName());
    private final List<ColumnInformation> fieldPackets;

    public DrizzleResultSetMetaData(List<ColumnInformation> fieldPackets) {
        this.fieldPackets = fieldPackets;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fieldPackets.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.getColumnInformation(column).getFlags().contains((Object)ColumnFlags.AUTO_INCREMENT);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getColumnInformation(column).getFlags().contains((Object)ColumnFlags.BINARY);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (this.getColumnInformation(column).getFlags().contains((Object)ColumnFlags.NOT_NULL)) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnInformation(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnInformation(column).getOriginalName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getColumnInformation(column).getDb();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumnInformation(column).getDecimals();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getColumnInformation(column).getTable();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getColumnInformation(column).getType().getSqlType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumnInformation(column).getType().toString();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getColumnInformation(column).getType().getJavaType().getName();
    }

    private ColumnInformation getColumnInformation(int column) throws SQLException {
        if (column - 1 >= 0 && column - 1 <= this.fieldPackets.size()) {
            return this.fieldPackets.get(column - 1);
        }
        throw new SQLException("No such column");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

