/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Logger;
import org.drizzle.jdbc.DrizzleConnection;
import org.drizzle.jdbc.DrizzleResultSet;
import org.drizzle.jdbc.DrizzleStatement;
import org.drizzle.jdbc.internal.SQLExceptionMapper;
import org.drizzle.jdbc.internal.common.ParameterizedBatchHandler;
import org.drizzle.jdbc.internal.common.Protocol;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.query.IllegalParameterException;
import org.drizzle.jdbc.internal.common.query.ParameterizedQuery;
import org.drizzle.jdbc.internal.common.query.QueryFactory;
import org.drizzle.jdbc.internal.common.query.parameters.BigDecimalParameter;
import org.drizzle.jdbc.internal.common.query.parameters.BufferedReaderParameter;
import org.drizzle.jdbc.internal.common.query.parameters.BufferedStreamParameter;
import org.drizzle.jdbc.internal.common.query.parameters.ByteParameter;
import org.drizzle.jdbc.internal.common.query.parameters.DateParameter;
import org.drizzle.jdbc.internal.common.query.parameters.DoubleParameter;
import org.drizzle.jdbc.internal.common.query.parameters.IntParameter;
import org.drizzle.jdbc.internal.common.query.parameters.LongParameter;
import org.drizzle.jdbc.internal.common.query.parameters.NullParameter;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;
import org.drizzle.jdbc.internal.common.query.parameters.ReaderParameter;
import org.drizzle.jdbc.internal.common.query.parameters.SerializableParameter;
import org.drizzle.jdbc.internal.common.query.parameters.StreamParameter;
import org.drizzle.jdbc.internal.common.query.parameters.StringParameter;
import org.drizzle.jdbc.internal.common.query.parameters.TimeParameter;
import org.drizzle.jdbc.internal.common.query.parameters.TimestampParameter;
import org.drizzle.jdbc.internal.common.queryresults.ModifyQueryResult;
import org.drizzle.jdbc.internal.common.queryresults.ResultSetType;

public class DrizzlePreparedStatement
extends DrizzleStatement
implements PreparedStatement {
    private static final Logger log = Logger.getLogger(DrizzlePreparedStatement.class.getName());
    private ParameterizedQuery dQuery;
    private final ParameterizedBatchHandler parameterizedBatchHandler;

    public DrizzlePreparedStatement(Protocol protocol, DrizzleConnection drizzleConnection, String query, QueryFactory queryFactory, ParameterizedBatchHandler parameterizedBatchHandler) {
        super(protocol, drizzleConnection, queryFactory);
        log.finest("Creating prepared statement for " + query);
        this.dQuery = queryFactory.createParameterizedQuery(query);
        this.parameterizedBatchHandler = parameterizedBatchHandler;
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            this.setQueryResult(this.getProtocol().executeQuery(this.dQuery));
            return new DrizzleResultSet(this.getQueryResult(), this);
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            this.setQueryResult(this.getProtocol().executeQuery(this.dQuery));
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
        if (this.getQueryResult().getResultSetType() != ResultSetType.MODIFY) {
            throw new SQLException("The query returned a result set");
        }
        return (int)((ModifyQueryResult)this.getQueryResult()).getUpdateCount();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    public boolean execute() throws SQLException {
        try {
            this.setQueryResult(this.getProtocol().executeQuery(this.dQuery));
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
        if (this.getQueryResult().getResultSetType() == ResultSetType.SELECT) {
            super.setResultSet(new DrizzleResultSet(this.getQueryResult(), this));
            return true;
        }
        this.setUpdateCount(((ModifyQueryResult)this.getQueryResult()).getUpdateCount());
        return false;
    }

    public void addBatch() throws SQLException {
        this.parameterizedBatchHandler.addToBatch(this.dQuery);
        this.dQuery = this.getQueryFactory().createParameterizedQuery(this.dQuery);
    }

    public int[] executeBatch() throws SQLException {
        try {
            return this.parameterizedBatchHandler.executeBatch();
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            this.setParameter(parameterIndex, new ReaderParameter(reader, length));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream: " + e.getMessage(), e);
        }
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        log.info("REFs not supported");
        throw new SQLFeatureNotSupportedException("REF not supported");
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        try {
            this.setParameter(parameterIndex, new StreamParameter(x.getBinaryStream(), x.length()));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream", e);
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Clobs not supported");
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Arrays not supported");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (super.getResultSet() != null) {
            return super.getResultSet().getMetaData();
        }
        return null;
    }

    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, new DateParameter(date.getTime(), cal));
    }

    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, new TimeParameter(time.getTime()));
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, new TimestampParameter(x.getTime(), cal));
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    private void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        try {
            this.dQuery.setParameter(parameterIndex - 1, holder);
        }
        catch (IllegalParameterException e) {
            throw new SQLException("Could not set parameter", e);
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParameter(parameterIndex, new StringParameter(x.toString()));
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("RowIDs not supported");
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException("NStrings not supported");
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("NCharstreams not supported");
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("NClobs not supported");
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Clobs not supported");
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        try {
            this.setParameter(parameterIndex, new StreamParameter(inputStream, length));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream", e);
        }
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("NClobs not supported");
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQlXML not supported");
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 70: 
            case 2002: 
            case 2003: 
            case 2005: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw new SQLFeatureNotSupportedException("Datatype not supported");
            }
            case 4: {
                if (x instanceof Number) {
                    this.setNumber(parameterIndex, (Number)x);
                    break;
                }
                this.setInt(parameterIndex, Integer.valueOf((String)x));
            }
        }
        throw new SQLFeatureNotSupportedException("Method not yet implemented");
    }

    private void setNumber(int parameterIndex, Number number) throws SQLException {
        if (number instanceof Integer) {
            this.setInt(parameterIndex, (Integer)number);
        } else if (number instanceof Short) {
            this.setShort(parameterIndex, (Short)number);
        } else {
            this.setLong(parameterIndex, number.longValue());
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this.setParameter(parameterIndex, new StreamParameter(x, length));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream", e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this.setParameter(parameterIndex, new StreamParameter(x, length));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream", e);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            this.setParameter(parameterIndex, new ReaderParameter(reader, length));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream: " + e.getMessage(), e);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this.setParameter(parameterIndex, new BufferedStreamParameter(x));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream");
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this.setParameter(parameterIndex, new BufferedStreamParameter(x));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream");
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        try {
            this.setParameter(parameterIndex, new BufferedReaderParameter(reader));
        }
        catch (IOException e) {
            throw new SQLException("Could not read reader", e);
        }
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("NChars not supported");
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("CLOBs not supported");
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        try {
            this.setParameter(parameterIndex, new BufferedStreamParameter(inputStream));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream");
        }
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("NClobs not supported");
    }

    public void setBoolean(int column, boolean value) throws SQLException {
        this.setParameter(column, new IntParameter(value ? 1 : 0));
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, new IntParameter(x));
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, new IntParameter(x));
    }

    public void setString(int column, String s) throws SQLException {
        this.setParameter(column, new StringParameter(s));
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParameter(parameterIndex, new ByteParameter(x));
    }

    public void setDate(int parameterIndex, Date date) throws SQLException {
        this.setParameter(parameterIndex, new DateParameter(date.getTime()));
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter(parameterIndex, new TimeParameter(x.getTime()));
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter(parameterIndex, new TimestampParameter(x.getTime()));
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.setParameter(parameterIndex, new StreamParameter(x, length));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream", e);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.setParameter(parameterIndex, new StreamParameter(x, length));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream", e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.setParameter(parameterIndex, new StreamParameter(x, length));
        }
        catch (IOException e) {
            throw new SQLException("Could not read stream", e);
        }
    }

    public void clearParameters() throws SQLException {
        this.dQuery.clearParameters();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not yet implemented");
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x);
        } else if (x instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)x);
        } else {
            try {
                this.setParameter(parameterIndex, new SerializableParameter(x));
            }
            catch (IOException e) {
                throw new SQLException("Could not set serializable parameter in setObject: " + e.getMessage(), e);
            }
        }
    }

    public void setInt(int column, int i) throws SQLException {
        this.setParameter(column, new IntParameter(i));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, new LongParameter(x));
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, new DoubleParameter(x));
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, new DoubleParameter(x));
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, new BigDecimalParameter(x));
    }
}

