/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.drizzle.jdbc.DrizzleConnection;
import org.drizzle.jdbc.internal.SQLExceptionMapper;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.query.DrizzleQueryFactory;
import org.drizzle.jdbc.internal.drizzle.DrizzleProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrizzleDataSource
implements DataSource {
    private final String hostname;
    private final int port;
    private final String database;

    public DrizzleDataSource(String hostname, int port, String database) {
        this.hostname = hostname;
        this.port = port;
        this.database = database;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return new DrizzleConnection(new DrizzleProtocol(this.hostname, this.port, this.database, null, null), new DrizzleQueryFactory());
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            return new DrizzleConnection(new DrizzleProtocol(this.hostname, this.port, this.database, username, password), new DrizzleQueryFactory());
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

