/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

public final class DrizzleBlob
extends OutputStream
implements Blob {
    private byte[] blobContent;
    private int actualSize;
    private static final int INITIAL_BLOB_CONTENT_SIZE = 100;

    public DrizzleBlob() {
    }

    public DrizzleBlob(byte[] bytes) {
        this.blobContent = bytes;
        this.actualSize = bytes.length;
    }

    public void write(int b) throws IOException {
        if (this.blobContent == null) {
            this.blobContent = new byte[100];
        }
        if (this.blobContent.length == this.actualSize) {
            this.blobContent = Arrays.copyOf(this.blobContent, this.blobContent.length * 2);
        }
        this.blobContent[this.actualSize++] = (byte)b;
    }

    public long length() throws SQLException {
        return this.actualSize;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Pos starts at 1");
        }
        return Arrays.copyOfRange(this.blobContent, (int)pos, (int)(pos + (long)length));
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.blobContent);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        if (start < 1L) {
            throw new SQLException("Start should be > 0, first position is 1.");
        }
        if (start > (long)this.actualSize) {
            throw new SQLException("Start should be <= " + this.actualSize);
        }
        long actualStart = start - 1L;
        for (int i = (int)actualStart; i < this.actualSize; ++i) {
            if (this.blobContent[i] != pattern[0]) continue;
            boolean isEqual = true;
            for (int j = 1; j < pattern.length; ++j) {
                if (i + j >= this.actualSize) {
                    return -1L;
                }
                if (this.blobContent[i + j] == pattern[j]) continue;
                isEqual = false;
            }
            if (!isEqual) continue;
            return i + 1;
        }
        return -1L;
    }

    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        int bytesWritten = 0;
        if (this.blobContent == null) {
            this.blobContent = new byte[(int)(pos + (long)bytes.length)];
            int i = (int)pos;
            while ((long)i < pos + (long)bytes.length) {
                this.blobContent[(int)(pos + (long)i)] = bytes[i];
                ++bytesWritten;
                ++i;
            }
        } else if ((long)this.blobContent.length < pos + (long)bytes.length) {
            int i = (int)pos;
            while ((long)i < pos + (long)bytes.length) {
                this.blobContent[(int)(pos + (long)i)] = bytes[i];
                ++bytesWritten;
                ++i;
            }
        }
        this.actualSize += bytesWritten;
        return bytesWritten;
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        int bytesWritten = 0;
        if (this.blobContent == null) {
            this.blobContent = new byte[(int)(pos + (long)bytes.length) - (len - offset)];
            for (int i = (int)pos + offset; i < len; ++i) {
                this.blobContent[(int)(pos + (long)i)] = bytes[i];
                ++bytesWritten;
            }
        } else if ((long)this.blobContent.length < pos + (long)bytes.length - (long)(len - offset)) {
            for (int i = (int)pos + offset; i < len; ++i) {
                this.blobContent[(int)(pos + (long)i)] = bytes[i];
                ++bytesWritten;
            }
        }
        this.actualSize += bytesWritten;
        return bytesWritten;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Invalid position in blob");
        }
        return new DrizzleBlob(Arrays.copyOfRange(this.blobContent, (int)pos - 1, this.blobContent.length + 1));
    }

    public void truncate(long len) throws SQLException {
        this.blobContent = Arrays.copyOf(this.blobContent, (int)len);
        this.actualSize = (int)len;
    }

    public void free() {
        this.blobContent = null;
        this.actualSize = 0;
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (pos < 1L || pos > (long)this.actualSize || pos + length > (long)this.actualSize) {
            throw new SQLException("Out of range");
        }
        return new ByteArrayInputStream(Arrays.copyOfRange(this.blobContent, (int)pos, (int)length));
    }
}

